/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditableRootPaths;
import io.fabric8.kubernetes.api.model.RootPaths;
import io.fabric8.kubernetes.api.model.RootPathsFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class RootPathsBuilder
extends RootPathsFluent<RootPathsBuilder>
implements VisitableBuilder<RootPaths, RootPathsBuilder> {
    RootPathsFluent<?> fluent;

    public RootPathsBuilder() {
        this(new RootPaths());
    }

    public RootPathsBuilder(RootPathsFluent<?> fluent) {
        this(fluent, new RootPaths());
    }

    public RootPathsBuilder(RootPathsFluent<?> fluent, RootPaths instance) {
        this.fluent = fluent;
        fluent.withPaths(instance.getPaths());
    }

    public RootPathsBuilder(RootPaths instance) {
        this.fluent = this;
        this.withPaths(instance.getPaths());
    }

    @Override
    public EditableRootPaths build() {
        EditableRootPaths buildable = new EditableRootPaths(this.fluent.getPaths());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RootPathsBuilder that = (RootPathsBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

