package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public class NamedTagEventListFluent<T extends NamedTagEventListFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     List<VisitableBuilder<TagEvent, ?>> items = new ArrayList();     String tag;     Map<String, Object> additionalProperties = new HashMap();

    public T addToItems( TagEvent ...items){
    for (TagEvent item : items) {TagEventBuilder builder = new TagEventBuilder(item);_visitables.add(builder);this.items.add(builder);} return (T)this;
    }
    public T removeFromItems( TagEvent ...items){
    for (TagEvent item : items) {TagEventBuilder builder = new TagEventBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (T)this;
    }
    public List<TagEvent> getItems(){
    return build(items);
    }
    public T withItems( List<TagEvent> items){
    this.items.clear();if (items != null) {for (TagEvent item : items){this.addToItems(item);}} return (T) this;
    }
    public T withItems( TagEvent ...items){
    this.items.clear(); if (items != null) {for (TagEvent item :items){ this.addToItems(item);}} return (T) this;
    }
    public ItemsNested<T> addNewItem(){
    return new ItemsNested<T>();
    }
    public ItemsNested<T> addNewItemLike( TagEvent item){
    return new ItemsNested<T>(item);
    }
    public T addNewItem( String created,  String dockerImageReference,  String image){
    return addToItems(new TagEvent(created, dockerImageReference, image));
    }
    public String getTag(){
    return this.tag;
    }
    public T withTag( String tag){
    this.tag=tag; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
NamedTagEventListFluent that = (NamedTagEventListFluent) o;
if (items != null ? !items.equals(that.items) :that.items != null) return false;
if (tag != null ? !tag.equals(that.tag) :that.tag != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class ItemsNested<N> extends TagEventFluent<ItemsNested<N>> implements Nested<N>{

        private final TagEventBuilder builder;
    
             ItemsNested ( TagEvent item){
        this.builder = new TagEventBuilder(this, item);
        }
             ItemsNested (){
        this.builder = new TagEventBuilder(this);
        }
    
            public N endItem(){
            return and();
        }
            public N and(){
            return (N) NamedTagEventListFluent.this.addToItems(builder.build());
        }
    
}


}
