package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.Map;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.util.List;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;

public class ClusterPolicyBindingFluent<T extends ClusterPolicyBindingFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     ClusterPolicyBinding.ApiVersion apiVersion;     String kind;     String lastModified;     VisitableBuilder<ObjectMeta, ?> metadata;     VisitableBuilder<ObjectReference, ?> policyRef;     List<VisitableBuilder<NamedClusterRoleBinding, ?>> roleBindings = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();

    public ClusterPolicyBinding.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( ClusterPolicyBinding.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public String getLastModified(){
    return this.lastModified;
    }
    public T withLastModified( String lastModified){
    this.lastModified=lastModified; return (T) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNested<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ObjectMeta item){
    return new MetadataNested<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public ObjectReference getPolicyRef(){
    return this.policyRef!=null?this.policyRef.build():null;
    }
    public T withPolicyRef( ObjectReference policyRef){
    if (policyRef!=null){ this.policyRef= new ObjectReferenceBuilder(policyRef); _visitables.add(this.policyRef);} return (T) this;
    }
    public PolicyRefNested<T> withNewPolicyRef(){
    return new PolicyRefNested<T>();
    }
    public PolicyRefNested<T> withNewPolicyRefLike( ObjectReference item){
    return new PolicyRefNested<T>(item);
    }
    public PolicyRefNested<T> editPolicyRef(){
    return withNewPolicyRefLike(getPolicyRef());
    }
    public T addToRoleBindings( NamedClusterRoleBinding ...items){
    for (NamedClusterRoleBinding item : items) {NamedClusterRoleBindingBuilder builder = new NamedClusterRoleBindingBuilder(item);_visitables.add(builder);this.roleBindings.add(builder);} return (T)this;
    }
    public T removeFromRoleBindings( NamedClusterRoleBinding ...items){
    for (NamedClusterRoleBinding item : items) {NamedClusterRoleBindingBuilder builder = new NamedClusterRoleBindingBuilder(item);_visitables.remove(builder);this.roleBindings.remove(builder);} return (T)this;
    }
    public List<NamedClusterRoleBinding> getRoleBindings(){
    return build(roleBindings);
    }
    public T withRoleBindings( List<NamedClusterRoleBinding> roleBindings){
    this.roleBindings.clear();if (roleBindings != null) {for (NamedClusterRoleBinding item : roleBindings){this.addToRoleBindings(item);}} return (T) this;
    }
    public T withRoleBindings( NamedClusterRoleBinding ...roleBindings){
    this.roleBindings.clear(); if (roleBindings != null) {for (NamedClusterRoleBinding item :roleBindings){ this.addToRoleBindings(item);}} return (T) this;
    }
    public RoleBindingsNested<T> addNewRoleBinding(){
    return new RoleBindingsNested<T>();
    }
    public RoleBindingsNested<T> addNewRoleBindingLike( NamedClusterRoleBinding item){
    return new RoleBindingsNested<T>(item);
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ClusterPolicyBindingFluent that = (ClusterPolicyBindingFluent) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (lastModified != null ? !lastModified.equals(that.lastModified) :that.lastModified != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (policyRef != null ? !policyRef.equals(that.policyRef) :that.policyRef != null) return false;
if (roleBindings != null ? !roleBindings.equals(that.roleBindings) :that.roleBindings != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNested ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
             MetadataNested (){
        this.builder = new ObjectMetaBuilder(this);
        }
    
            public N and(){
            return (N) ClusterPolicyBindingFluent.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}
    public class PolicyRefNested<N> extends ObjectReferenceFluent<PolicyRefNested<N>> implements Nested<N>{

        private final ObjectReferenceBuilder builder;
    
             PolicyRefNested (){
        this.builder = new ObjectReferenceBuilder(this);
        }
             PolicyRefNested ( ObjectReference item){
        this.builder = new ObjectReferenceBuilder(this, item);
        }
    
            public N endPolicyRef(){
            return and();
        }
            public N and(){
            return (N) ClusterPolicyBindingFluent.this.withPolicyRef(builder.build());
        }
    
}
    public class RoleBindingsNested<N> extends NamedClusterRoleBindingFluent<RoleBindingsNested<N>> implements Nested<N>{

        private final NamedClusterRoleBindingBuilder builder;
    
             RoleBindingsNested (){
        this.builder = new NamedClusterRoleBindingBuilder(this);
        }
             RoleBindingsNested ( NamedClusterRoleBinding item){
        this.builder = new NamedClusterRoleBindingBuilder(this, item);
        }
    
            public N endRoleBinding(){
            return and();
        }
            public N and(){
            return (N) ClusterPolicyBindingFluent.this.addToRoleBindings(builder.build());
        }
    
}


}
