/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.internal;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesKind;
import java.util.Comparator;

public class HasMetadataComparator
implements Comparator<HasMetadata> {
    private Integer getKindValue(String kind) {
        try {
            KubernetesKind kindOrder = KubernetesKind.valueOf(kind);
            switch (kindOrder) {
                case SecurityContextConstraints: {
                    return 0;
                }
                case Secret: {
                    return 1;
                }
                case ServiceAccount: {
                    return 2;
                }
                case OAuthClient: {
                    return 3;
                }
                case Service: {
                    return 4;
                }
                case PersistentVolume: {
                    return 5;
                }
                case PersistentVolumeClaim: {
                    return 6;
                }
            }
            return 100;
        }
        catch (IllegalArgumentException e) {
            return 100;
        }
    }

    @Override
    public int compare(HasMetadata a, HasMetadata b) {
        String classNameB;
        if (a == null || b == null) {
            throw new NullPointerException("Cannot compare null HasMetadata objects");
        }
        if (a == b || a.equals(b)) {
            return 0;
        }
        int kindOrderCompare = this.getKindValue(a.getKind()).compareTo(this.getKindValue(b.getKind()));
        if (kindOrderCompare != 0) {
            return kindOrderCompare;
        }
        String classNameA = a.getClass().getSimpleName();
        int classCompare = classNameA.compareTo(classNameB = b.getClass().getSimpleName());
        if (classCompare != 0) {
            return classCompare;
        }
        return a.getMetadata().getName().compareTo(b.getMetadata().getName());
    }
}

