package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.ArrayList;
import java.util.Map;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.ServiceAccountBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ResourceQuotaFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeFluent;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.NodeFluent;
import io.fabric8.kubernetes.api.model.ResourceQuotaBuilder;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.EventFluent;
import io.fabric8.kubernetes.api.model.EndpointsBuilder;
import io.fabric8.kubernetes.api.model.ServiceAccountFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeBuilder;
import io.fabric8.kubernetes.api.model.SecurityContextConstraints;
import io.fabric8.kubernetes.api.model.EventBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.PersistentVolume;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NodeBuilder;
import io.fabric8.kubernetes.api.model.EndpointsFluent;
import io.fabric8.kubernetes.api.model.SecurityContextConstraintsFluent;
import io.fabric8.kubernetes.api.model.SecurityContextConstraintsBuilder;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.ServiceFluent;

public class TemplateFluent<T extends TemplateFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     Template.ApiVersion apiVersion;     String kind;     Map<String, String> labels = new HashMap();     VisitableBuilder<ObjectMeta, ?> metadata;     List<HasMetadata> objects = new ArrayList();     List<VisitableBuilder<Role, ?>> roleObjects = new ArrayList();     List<VisitableBuilder<OAuthAccessToken, ?>> oAuthAccessTokenObjects = new ArrayList();     List<VisitableBuilder<Route, ?>> routeObjects = new ArrayList();     List<VisitableBuilder<Namespace, ?>> namespaceObjects = new ArrayList();     List<VisitableBuilder<ServiceAccount, ?>> serviceAccountObjects = new ArrayList();     List<VisitableBuilder<User, ?>> userObjects = new ArrayList();     List<VisitableBuilder<ClusterRoleBinding, ?>> clusterRoleBindingObjects = new ArrayList();     List<VisitableBuilder<DeploymentConfig, ?>> deploymentConfigObjects = new ArrayList();     List<VisitableBuilder<OAuthAuthorizeToken, ?>> oAuthAuthorizeTokenObjects = new ArrayList();     List<VisitableBuilder<Image, ?>> imageObjects = new ArrayList();     List<VisitableBuilder<ClusterRole, ?>> clusterRoleObjects = new ArrayList();     List<VisitableBuilder<Event, ?>> eventObjects = new ArrayList();     List<VisitableBuilder<ResourceQuota, ?>> resourceQuotaObjects = new ArrayList();     List<VisitableBuilder<Group, ?>> groupObjects = new ArrayList();     List<VisitableBuilder<PersistentVolumeClaim, ?>> persistentVolumeClaimObjects = new ArrayList();     List<VisitableBuilder<BuildConfig, ?>> buildConfigObjects = new ArrayList();     List<VisitableBuilder<ImageStream, ?>> imageStreamObjects = new ArrayList();     List<VisitableBuilder<OAuthClientAuthorization, ?>> oAuthClientAuthorizationObjects = new ArrayList();     List<VisitableBuilder<PersistentVolume, ?>> persistentVolumeObjects = new ArrayList();     List<VisitableBuilder<Policy, ?>> policyObjects = new ArrayList();     List<VisitableBuilder<PolicyBinding, ?>> policyBindingObjects = new ArrayList();     List<VisitableBuilder<ReplicationController, ?>> replicationControllerObjects = new ArrayList();     List<VisitableBuilder<ClusterPolicyBinding, ?>> clusterPolicyBindingObjects = new ArrayList();     List<VisitableBuilder<ClusterPolicy, ?>> clusterPolicyObjects = new ArrayList();     List<VisitableBuilder<Identity, ?>> identityObjects = new ArrayList();     List<VisitableBuilder<Node, ?>> nodeObjects = new ArrayList();     List<VisitableBuilder<Secret, ?>> secretObjects = new ArrayList();     List<VisitableBuilder<Build, ?>> buildObjects = new ArrayList();     List<VisitableBuilder<Endpoints, ?>> endpointsObjects = new ArrayList();     List<VisitableBuilder<RoleBinding, ?>> roleBindingObjects = new ArrayList();     List<VisitableBuilder<BuildRequest, ?>> buildRequestObjects = new ArrayList();     List<VisitableBuilder<Pod, ?>> podObjects = new ArrayList();     List<VisitableBuilder<Service, ?>> serviceObjects = new ArrayList();     List<VisitableBuilder<OAuthClient, ?>> oAuthClientObjects = new ArrayList();     List<VisitableBuilder<Template, ?>> templateObjects = new ArrayList();     List<VisitableBuilder<SecurityContextConstraints, ?>> securityContextConstraintsObjects = new ArrayList();     List<VisitableBuilder<Parameter, ?>> parameters = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();

    public Template.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( Template.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public T addToLabels( String key,  String value){
    if(key != null && value != null) {this.labels.put(key, value);} return (T)this;
    }
    public T removeFromLabels( String key){
    if(key != null) {this.labels.remove(key);} return (T)this;
    }
    public Map<String, String> getLabels(){
    return this.labels;
    }
    public T withLabels( Map<String, String> labels){
    this.labels.clear();if (labels != null) {this.labels.putAll(labels);} return (T) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNested<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ObjectMeta item){
    return new MetadataNested<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public T addToObjects( HasMetadata ...items){
    for (HasMetadata item : items) {if (item instanceof Role){addToRoleObjects((Role)item);}
 else if (item instanceof OAuthAccessToken){addToOAuthAccessTokenObjects((OAuthAccessToken)item);}
 else if (item instanceof Route){addToRouteObjects((Route)item);}
 else if (item instanceof Namespace){addToNamespaceObjects((Namespace)item);}
 else if (item instanceof ServiceAccount){addToServiceAccountObjects((ServiceAccount)item);}
 else if (item instanceof User){addToUserObjects((User)item);}
 else if (item instanceof ClusterRoleBinding){addToClusterRoleBindingObjects((ClusterRoleBinding)item);}
 else if (item instanceof DeploymentConfig){addToDeploymentConfigObjects((DeploymentConfig)item);}
 else if (item instanceof OAuthAuthorizeToken){addToOAuthAuthorizeTokenObjects((OAuthAuthorizeToken)item);}
 else if (item instanceof Image){addToImageObjects((Image)item);}
 else if (item instanceof ClusterRole){addToClusterRoleObjects((ClusterRole)item);}
 else if (item instanceof Event){addToEventObjects((Event)item);}
 else if (item instanceof ResourceQuota){addToResourceQuotaObjects((ResourceQuota)item);}
 else if (item instanceof Group){addToGroupObjects((Group)item);}
 else if (item instanceof PersistentVolumeClaim){addToPersistentVolumeClaimObjects((PersistentVolumeClaim)item);}
 else if (item instanceof BuildConfig){addToBuildConfigObjects((BuildConfig)item);}
 else if (item instanceof ImageStream){addToImageStreamObjects((ImageStream)item);}
 else if (item instanceof OAuthClientAuthorization){addToOAuthClientAuthorizationObjects((OAuthClientAuthorization)item);}
 else if (item instanceof PersistentVolume){addToPersistentVolumeObjects((PersistentVolume)item);}
 else if (item instanceof Policy){addToPolicyObjects((Policy)item);}
 else if (item instanceof PolicyBinding){addToPolicyBindingObjects((PolicyBinding)item);}
 else if (item instanceof ReplicationController){addToReplicationControllerObjects((ReplicationController)item);}
 else if (item instanceof ClusterPolicyBinding){addToClusterPolicyBindingObjects((ClusterPolicyBinding)item);}
 else if (item instanceof ClusterPolicy){addToClusterPolicyObjects((ClusterPolicy)item);}
 else if (item instanceof Identity){addToIdentityObjects((Identity)item);}
 else if (item instanceof Node){addToNodeObjects((Node)item);}
 else if (item instanceof Secret){addToSecretObjects((Secret)item);}
 else if (item instanceof Build){addToBuildObjects((Build)item);}
 else if (item instanceof Endpoints){addToEndpointsObjects((Endpoints)item);}
 else if (item instanceof RoleBinding){addToRoleBindingObjects((RoleBinding)item);}
 else if (item instanceof BuildRequest){addToBuildRequestObjects((BuildRequest)item);}
 else if (item instanceof Pod){addToPodObjects((Pod)item);}
 else if (item instanceof Service){addToServiceObjects((Service)item);}
 else if (item instanceof OAuthClient){addToOAuthClientObjects((OAuthClient)item);}
 else if (item instanceof Template){addToTemplateObjects((Template)item);}
 else if (item instanceof SecurityContextConstraints){addToSecurityContextConstraintsObjects((SecurityContextConstraints)item);}
} return (T)this;
    }
    public T removeFromObjects( HasMetadata ...items){
    for (HasMetadata item : items) {if (item instanceof Role){removeFromRoleObjects((Role)item);}
 else if (item instanceof OAuthAccessToken){removeFromOAuthAccessTokenObjects((OAuthAccessToken)item);}
 else if (item instanceof Route){removeFromRouteObjects((Route)item);}
 else if (item instanceof Namespace){removeFromNamespaceObjects((Namespace)item);}
 else if (item instanceof ServiceAccount){removeFromServiceAccountObjects((ServiceAccount)item);}
 else if (item instanceof User){removeFromUserObjects((User)item);}
 else if (item instanceof ClusterRoleBinding){removeFromClusterRoleBindingObjects((ClusterRoleBinding)item);}
 else if (item instanceof DeploymentConfig){removeFromDeploymentConfigObjects((DeploymentConfig)item);}
 else if (item instanceof OAuthAuthorizeToken){removeFromOAuthAuthorizeTokenObjects((OAuthAuthorizeToken)item);}
 else if (item instanceof Image){removeFromImageObjects((Image)item);}
 else if (item instanceof ClusterRole){removeFromClusterRoleObjects((ClusterRole)item);}
 else if (item instanceof Event){removeFromEventObjects((Event)item);}
 else if (item instanceof ResourceQuota){removeFromResourceQuotaObjects((ResourceQuota)item);}
 else if (item instanceof Group){removeFromGroupObjects((Group)item);}
 else if (item instanceof PersistentVolumeClaim){removeFromPersistentVolumeClaimObjects((PersistentVolumeClaim)item);}
 else if (item instanceof BuildConfig){removeFromBuildConfigObjects((BuildConfig)item);}
 else if (item instanceof ImageStream){removeFromImageStreamObjects((ImageStream)item);}
 else if (item instanceof OAuthClientAuthorization){removeFromOAuthClientAuthorizationObjects((OAuthClientAuthorization)item);}
 else if (item instanceof PersistentVolume){removeFromPersistentVolumeObjects((PersistentVolume)item);}
 else if (item instanceof Policy){removeFromPolicyObjects((Policy)item);}
 else if (item instanceof PolicyBinding){removeFromPolicyBindingObjects((PolicyBinding)item);}
 else if (item instanceof ReplicationController){removeFromReplicationControllerObjects((ReplicationController)item);}
 else if (item instanceof ClusterPolicyBinding){removeFromClusterPolicyBindingObjects((ClusterPolicyBinding)item);}
 else if (item instanceof ClusterPolicy){removeFromClusterPolicyObjects((ClusterPolicy)item);}
 else if (item instanceof Identity){removeFromIdentityObjects((Identity)item);}
 else if (item instanceof Node){removeFromNodeObjects((Node)item);}
 else if (item instanceof Secret){removeFromSecretObjects((Secret)item);}
 else if (item instanceof Build){removeFromBuildObjects((Build)item);}
 else if (item instanceof Endpoints){removeFromEndpointsObjects((Endpoints)item);}
 else if (item instanceof RoleBinding){removeFromRoleBindingObjects((RoleBinding)item);}
 else if (item instanceof BuildRequest){removeFromBuildRequestObjects((BuildRequest)item);}
 else if (item instanceof Pod){removeFromPodObjects((Pod)item);}
 else if (item instanceof Service){removeFromServiceObjects((Service)item);}
 else if (item instanceof OAuthClient){removeFromOAuthClientObjects((OAuthClient)item);}
 else if (item instanceof Template){removeFromTemplateObjects((Template)item);}
 else if (item instanceof SecurityContextConstraints){removeFromSecurityContextConstraintsObjects((SecurityContextConstraints)item);}
} return (T)this;
    }
    public List<HasMetadata> getObjects(){
    return aggregate(build(roleObjects), build(oAuthAccessTokenObjects), build(routeObjects), build(namespaceObjects), build(serviceAccountObjects), build(userObjects), build(clusterRoleBindingObjects), build(deploymentConfigObjects), build(oAuthAuthorizeTokenObjects), build(imageObjects), build(clusterRoleObjects), build(eventObjects), build(resourceQuotaObjects), build(groupObjects), build(persistentVolumeClaimObjects), build(buildConfigObjects), build(imageStreamObjects), build(oAuthClientAuthorizationObjects), build(persistentVolumeObjects), build(policyObjects), build(policyBindingObjects), build(replicationControllerObjects), build(clusterPolicyBindingObjects), build(clusterPolicyObjects), build(identityObjects), build(nodeObjects), build(secretObjects), build(buildObjects), build(endpointsObjects), build(roleBindingObjects), build(buildRequestObjects), build(podObjects), build(serviceObjects), build(oAuthClientObjects), build(templateObjects), build(securityContextConstraintsObjects));
    }
    public T withObjects( List<HasMetadata> objects){
    this.objects.clear();if (objects != null) {for (HasMetadata item : objects){this.addToObjects(item);}} return (T) this;
    }
    public T withObjects( HasMetadata ...objects){
    this.objects.clear(); if (objects != null) {for (HasMetadata item :objects){ this.addToObjects(item);}} return (T) this;
    }
    public T addToRoleObjects( Role ...items){
    for (Role item : items) {RoleBuilder builder = new RoleBuilder(item);_visitables.add(builder);this.roleObjects.add(builder);} return (T)this;
    }
    public T removeFromRoleObjects( Role ...items){
    for (Role item : items) {RoleBuilder builder = new RoleBuilder(item);_visitables.remove(builder);this.roleObjects.remove(builder);} return (T)this;
    }
    public RoleObjectsNested<T> addNewRoleObject(){
    return new RoleObjectsNested<T>();
    }
    public RoleObjectsNested<T> addNewRoleObjectLike( Role item){
    return new RoleObjectsNested<T>(item);
    }
    public T addToOAuthAccessTokenObjects( OAuthAccessToken ...items){
    for (OAuthAccessToken item : items) {OAuthAccessTokenBuilder builder = new OAuthAccessTokenBuilder(item);_visitables.add(builder);this.oAuthAccessTokenObjects.add(builder);} return (T)this;
    }
    public T removeFromOAuthAccessTokenObjects( OAuthAccessToken ...items){
    for (OAuthAccessToken item : items) {OAuthAccessTokenBuilder builder = new OAuthAccessTokenBuilder(item);_visitables.remove(builder);this.oAuthAccessTokenObjects.remove(builder);} return (T)this;
    }
    public OAuthAccessTokenObjectsNested<T> addNewOAuthAccessTokenObject(){
    return new OAuthAccessTokenObjectsNested<T>();
    }
    public OAuthAccessTokenObjectsNested<T> addNewOAuthAccessTokenObjectLike( OAuthAccessToken item){
    return new OAuthAccessTokenObjectsNested<T>(item);
    }
    public T addToRouteObjects( Route ...items){
    for (Route item : items) {RouteBuilder builder = new RouteBuilder(item);_visitables.add(builder);this.routeObjects.add(builder);} return (T)this;
    }
    public T removeFromRouteObjects( Route ...items){
    for (Route item : items) {RouteBuilder builder = new RouteBuilder(item);_visitables.remove(builder);this.routeObjects.remove(builder);} return (T)this;
    }
    public RouteObjectsNested<T> addNewRouteObject(){
    return new RouteObjectsNested<T>();
    }
    public RouteObjectsNested<T> addNewRouteObjectLike( Route item){
    return new RouteObjectsNested<T>(item);
    }
    public T addToNamespaceObjects( Namespace ...items){
    for (Namespace item : items) {NamespaceBuilder builder = new NamespaceBuilder(item);_visitables.add(builder);this.namespaceObjects.add(builder);} return (T)this;
    }
    public T removeFromNamespaceObjects( Namespace ...items){
    for (Namespace item : items) {NamespaceBuilder builder = new NamespaceBuilder(item);_visitables.remove(builder);this.namespaceObjects.remove(builder);} return (T)this;
    }
    public NamespaceObjectsNested<T> addNewNamespaceObject(){
    return new NamespaceObjectsNested<T>();
    }
    public NamespaceObjectsNested<T> addNewNamespaceObjectLike( Namespace item){
    return new NamespaceObjectsNested<T>(item);
    }
    public T addToServiceAccountObjects( ServiceAccount ...items){
    for (ServiceAccount item : items) {ServiceAccountBuilder builder = new ServiceAccountBuilder(item);_visitables.add(builder);this.serviceAccountObjects.add(builder);} return (T)this;
    }
    public T removeFromServiceAccountObjects( ServiceAccount ...items){
    for (ServiceAccount item : items) {ServiceAccountBuilder builder = new ServiceAccountBuilder(item);_visitables.remove(builder);this.serviceAccountObjects.remove(builder);} return (T)this;
    }
    public ServiceAccountObjectsNested<T> addNewServiceAccountObject(){
    return new ServiceAccountObjectsNested<T>();
    }
    public ServiceAccountObjectsNested<T> addNewServiceAccountObjectLike( ServiceAccount item){
    return new ServiceAccountObjectsNested<T>(item);
    }
    public T addToUserObjects( User ...items){
    for (User item : items) {UserBuilder builder = new UserBuilder(item);_visitables.add(builder);this.userObjects.add(builder);} return (T)this;
    }
    public T removeFromUserObjects( User ...items){
    for (User item : items) {UserBuilder builder = new UserBuilder(item);_visitables.remove(builder);this.userObjects.remove(builder);} return (T)this;
    }
    public UserObjectsNested<T> addNewUserObject(){
    return new UserObjectsNested<T>();
    }
    public UserObjectsNested<T> addNewUserObjectLike( User item){
    return new UserObjectsNested<T>(item);
    }
    public T addToClusterRoleBindingObjects( ClusterRoleBinding ...items){
    for (ClusterRoleBinding item : items) {ClusterRoleBindingBuilder builder = new ClusterRoleBindingBuilder(item);_visitables.add(builder);this.clusterRoleBindingObjects.add(builder);} return (T)this;
    }
    public T removeFromClusterRoleBindingObjects( ClusterRoleBinding ...items){
    for (ClusterRoleBinding item : items) {ClusterRoleBindingBuilder builder = new ClusterRoleBindingBuilder(item);_visitables.remove(builder);this.clusterRoleBindingObjects.remove(builder);} return (T)this;
    }
    public ClusterRoleBindingObjectsNested<T> addNewClusterRoleBindingObject(){
    return new ClusterRoleBindingObjectsNested<T>();
    }
    public ClusterRoleBindingObjectsNested<T> addNewClusterRoleBindingObjectLike( ClusterRoleBinding item){
    return new ClusterRoleBindingObjectsNested<T>(item);
    }
    public T addToDeploymentConfigObjects( DeploymentConfig ...items){
    for (DeploymentConfig item : items) {DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);_visitables.add(builder);this.deploymentConfigObjects.add(builder);} return (T)this;
    }
    public T removeFromDeploymentConfigObjects( DeploymentConfig ...items){
    for (DeploymentConfig item : items) {DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);_visitables.remove(builder);this.deploymentConfigObjects.remove(builder);} return (T)this;
    }
    public DeploymentConfigObjectsNested<T> addNewDeploymentConfigObject(){
    return new DeploymentConfigObjectsNested<T>();
    }
    public DeploymentConfigObjectsNested<T> addNewDeploymentConfigObjectLike( DeploymentConfig item){
    return new DeploymentConfigObjectsNested<T>(item);
    }
    public T addToOAuthAuthorizeTokenObjects( OAuthAuthorizeToken ...items){
    for (OAuthAuthorizeToken item : items) {OAuthAuthorizeTokenBuilder builder = new OAuthAuthorizeTokenBuilder(item);_visitables.add(builder);this.oAuthAuthorizeTokenObjects.add(builder);} return (T)this;
    }
    public T removeFromOAuthAuthorizeTokenObjects( OAuthAuthorizeToken ...items){
    for (OAuthAuthorizeToken item : items) {OAuthAuthorizeTokenBuilder builder = new OAuthAuthorizeTokenBuilder(item);_visitables.remove(builder);this.oAuthAuthorizeTokenObjects.remove(builder);} return (T)this;
    }
    public OAuthAuthorizeTokenObjectsNested<T> addNewOAuthAuthorizeTokenObject(){
    return new OAuthAuthorizeTokenObjectsNested<T>();
    }
    public OAuthAuthorizeTokenObjectsNested<T> addNewOAuthAuthorizeTokenObjectLike( OAuthAuthorizeToken item){
    return new OAuthAuthorizeTokenObjectsNested<T>(item);
    }
    public T addToImageObjects( Image ...items){
    for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.add(builder);this.imageObjects.add(builder);} return (T)this;
    }
    public T removeFromImageObjects( Image ...items){
    for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.remove(builder);this.imageObjects.remove(builder);} return (T)this;
    }
    public ImageObjectsNested<T> addNewImageObject(){
    return new ImageObjectsNested<T>();
    }
    public ImageObjectsNested<T> addNewImageObjectLike( Image item){
    return new ImageObjectsNested<T>(item);
    }
    public T addToClusterRoleObjects( ClusterRole ...items){
    for (ClusterRole item : items) {ClusterRoleBuilder builder = new ClusterRoleBuilder(item);_visitables.add(builder);this.clusterRoleObjects.add(builder);} return (T)this;
    }
    public T removeFromClusterRoleObjects( ClusterRole ...items){
    for (ClusterRole item : items) {ClusterRoleBuilder builder = new ClusterRoleBuilder(item);_visitables.remove(builder);this.clusterRoleObjects.remove(builder);} return (T)this;
    }
    public ClusterRoleObjectsNested<T> addNewClusterRoleObject(){
    return new ClusterRoleObjectsNested<T>();
    }
    public ClusterRoleObjectsNested<T> addNewClusterRoleObjectLike( ClusterRole item){
    return new ClusterRoleObjectsNested<T>(item);
    }
    public T addToEventObjects( Event ...items){
    for (Event item : items) {EventBuilder builder = new EventBuilder(item);_visitables.add(builder);this.eventObjects.add(builder);} return (T)this;
    }
    public T removeFromEventObjects( Event ...items){
    for (Event item : items) {EventBuilder builder = new EventBuilder(item);_visitables.remove(builder);this.eventObjects.remove(builder);} return (T)this;
    }
    public EventObjectsNested<T> addNewEventObject(){
    return new EventObjectsNested<T>();
    }
    public EventObjectsNested<T> addNewEventObjectLike( Event item){
    return new EventObjectsNested<T>(item);
    }
    public T addToResourceQuotaObjects( ResourceQuota ...items){
    for (ResourceQuota item : items) {ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);_visitables.add(builder);this.resourceQuotaObjects.add(builder);} return (T)this;
    }
    public T removeFromResourceQuotaObjects( ResourceQuota ...items){
    for (ResourceQuota item : items) {ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);_visitables.remove(builder);this.resourceQuotaObjects.remove(builder);} return (T)this;
    }
    public ResourceQuotaObjectsNested<T> addNewResourceQuotaObject(){
    return new ResourceQuotaObjectsNested<T>();
    }
    public ResourceQuotaObjectsNested<T> addNewResourceQuotaObjectLike( ResourceQuota item){
    return new ResourceQuotaObjectsNested<T>(item);
    }
    public T addToGroupObjects( Group ...items){
    for (Group item : items) {GroupBuilder builder = new GroupBuilder(item);_visitables.add(builder);this.groupObjects.add(builder);} return (T)this;
    }
    public T removeFromGroupObjects( Group ...items){
    for (Group item : items) {GroupBuilder builder = new GroupBuilder(item);_visitables.remove(builder);this.groupObjects.remove(builder);} return (T)this;
    }
    public GroupObjectsNested<T> addNewGroupObject(){
    return new GroupObjectsNested<T>();
    }
    public GroupObjectsNested<T> addNewGroupObjectLike( Group item){
    return new GroupObjectsNested<T>(item);
    }
    public T addToPersistentVolumeClaimObjects( PersistentVolumeClaim ...items){
    for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.add(builder);this.persistentVolumeClaimObjects.add(builder);} return (T)this;
    }
    public T removeFromPersistentVolumeClaimObjects( PersistentVolumeClaim ...items){
    for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.remove(builder);this.persistentVolumeClaimObjects.remove(builder);} return (T)this;
    }
    public PersistentVolumeClaimObjectsNested<T> addNewPersistentVolumeClaimObject(){
    return new PersistentVolumeClaimObjectsNested<T>();
    }
    public PersistentVolumeClaimObjectsNested<T> addNewPersistentVolumeClaimObjectLike( PersistentVolumeClaim item){
    return new PersistentVolumeClaimObjectsNested<T>(item);
    }
    public T addToBuildConfigObjects( BuildConfig ...items){
    for (BuildConfig item : items) {BuildConfigBuilder builder = new BuildConfigBuilder(item);_visitables.add(builder);this.buildConfigObjects.add(builder);} return (T)this;
    }
    public T removeFromBuildConfigObjects( BuildConfig ...items){
    for (BuildConfig item : items) {BuildConfigBuilder builder = new BuildConfigBuilder(item);_visitables.remove(builder);this.buildConfigObjects.remove(builder);} return (T)this;
    }
    public BuildConfigObjectsNested<T> addNewBuildConfigObject(){
    return new BuildConfigObjectsNested<T>();
    }
    public BuildConfigObjectsNested<T> addNewBuildConfigObjectLike( BuildConfig item){
    return new BuildConfigObjectsNested<T>(item);
    }
    public T addToImageStreamObjects( ImageStream ...items){
    for (ImageStream item : items) {ImageStreamBuilder builder = new ImageStreamBuilder(item);_visitables.add(builder);this.imageStreamObjects.add(builder);} return (T)this;
    }
    public T removeFromImageStreamObjects( ImageStream ...items){
    for (ImageStream item : items) {ImageStreamBuilder builder = new ImageStreamBuilder(item);_visitables.remove(builder);this.imageStreamObjects.remove(builder);} return (T)this;
    }
    public ImageStreamObjectsNested<T> addNewImageStreamObject(){
    return new ImageStreamObjectsNested<T>();
    }
    public ImageStreamObjectsNested<T> addNewImageStreamObjectLike( ImageStream item){
    return new ImageStreamObjectsNested<T>(item);
    }
    public T addToOAuthClientAuthorizationObjects( OAuthClientAuthorization ...items){
    for (OAuthClientAuthorization item : items) {OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(item);_visitables.add(builder);this.oAuthClientAuthorizationObjects.add(builder);} return (T)this;
    }
    public T removeFromOAuthClientAuthorizationObjects( OAuthClientAuthorization ...items){
    for (OAuthClientAuthorization item : items) {OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(item);_visitables.remove(builder);this.oAuthClientAuthorizationObjects.remove(builder);} return (T)this;
    }
    public OAuthClientAuthorizationObjectsNested<T> addNewOAuthClientAuthorizationObject(){
    return new OAuthClientAuthorizationObjectsNested<T>();
    }
    public OAuthClientAuthorizationObjectsNested<T> addNewOAuthClientAuthorizationObjectLike( OAuthClientAuthorization item){
    return new OAuthClientAuthorizationObjectsNested<T>(item);
    }
    public T addToPersistentVolumeObjects( PersistentVolume ...items){
    for (PersistentVolume item : items) {PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);_visitables.add(builder);this.persistentVolumeObjects.add(builder);} return (T)this;
    }
    public T removeFromPersistentVolumeObjects( PersistentVolume ...items){
    for (PersistentVolume item : items) {PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);_visitables.remove(builder);this.persistentVolumeObjects.remove(builder);} return (T)this;
    }
    public PersistentVolumeObjectsNested<T> addNewPersistentVolumeObject(){
    return new PersistentVolumeObjectsNested<T>();
    }
    public PersistentVolumeObjectsNested<T> addNewPersistentVolumeObjectLike( PersistentVolume item){
    return new PersistentVolumeObjectsNested<T>(item);
    }
    public T addToPolicyObjects( Policy ...items){
    for (Policy item : items) {PolicyBuilder builder = new PolicyBuilder(item);_visitables.add(builder);this.policyObjects.add(builder);} return (T)this;
    }
    public T removeFromPolicyObjects( Policy ...items){
    for (Policy item : items) {PolicyBuilder builder = new PolicyBuilder(item);_visitables.remove(builder);this.policyObjects.remove(builder);} return (T)this;
    }
    public PolicyObjectsNested<T> addNewPolicyObject(){
    return new PolicyObjectsNested<T>();
    }
    public PolicyObjectsNested<T> addNewPolicyObjectLike( Policy item){
    return new PolicyObjectsNested<T>(item);
    }
    public T addToPolicyBindingObjects( PolicyBinding ...items){
    for (PolicyBinding item : items) {PolicyBindingBuilder builder = new PolicyBindingBuilder(item);_visitables.add(builder);this.policyBindingObjects.add(builder);} return (T)this;
    }
    public T removeFromPolicyBindingObjects( PolicyBinding ...items){
    for (PolicyBinding item : items) {PolicyBindingBuilder builder = new PolicyBindingBuilder(item);_visitables.remove(builder);this.policyBindingObjects.remove(builder);} return (T)this;
    }
    public PolicyBindingObjectsNested<T> addNewPolicyBindingObject(){
    return new PolicyBindingObjectsNested<T>();
    }
    public PolicyBindingObjectsNested<T> addNewPolicyBindingObjectLike( PolicyBinding item){
    return new PolicyBindingObjectsNested<T>(item);
    }
    public T addToReplicationControllerObjects( ReplicationController ...items){
    for (ReplicationController item : items) {ReplicationControllerBuilder builder = new ReplicationControllerBuilder(item);_visitables.add(builder);this.replicationControllerObjects.add(builder);} return (T)this;
    }
    public T removeFromReplicationControllerObjects( ReplicationController ...items){
    for (ReplicationController item : items) {ReplicationControllerBuilder builder = new ReplicationControllerBuilder(item);_visitables.remove(builder);this.replicationControllerObjects.remove(builder);} return (T)this;
    }
    public ReplicationControllerObjectsNested<T> addNewReplicationControllerObject(){
    return new ReplicationControllerObjectsNested<T>();
    }
    public ReplicationControllerObjectsNested<T> addNewReplicationControllerObjectLike( ReplicationController item){
    return new ReplicationControllerObjectsNested<T>(item);
    }
    public T addToClusterPolicyBindingObjects( ClusterPolicyBinding ...items){
    for (ClusterPolicyBinding item : items) {ClusterPolicyBindingBuilder builder = new ClusterPolicyBindingBuilder(item);_visitables.add(builder);this.clusterPolicyBindingObjects.add(builder);} return (T)this;
    }
    public T removeFromClusterPolicyBindingObjects( ClusterPolicyBinding ...items){
    for (ClusterPolicyBinding item : items) {ClusterPolicyBindingBuilder builder = new ClusterPolicyBindingBuilder(item);_visitables.remove(builder);this.clusterPolicyBindingObjects.remove(builder);} return (T)this;
    }
    public ClusterPolicyBindingObjectsNested<T> addNewClusterPolicyBindingObject(){
    return new ClusterPolicyBindingObjectsNested<T>();
    }
    public ClusterPolicyBindingObjectsNested<T> addNewClusterPolicyBindingObjectLike( ClusterPolicyBinding item){
    return new ClusterPolicyBindingObjectsNested<T>(item);
    }
    public T addToClusterPolicyObjects( ClusterPolicy ...items){
    for (ClusterPolicy item : items) {ClusterPolicyBuilder builder = new ClusterPolicyBuilder(item);_visitables.add(builder);this.clusterPolicyObjects.add(builder);} return (T)this;
    }
    public T removeFromClusterPolicyObjects( ClusterPolicy ...items){
    for (ClusterPolicy item : items) {ClusterPolicyBuilder builder = new ClusterPolicyBuilder(item);_visitables.remove(builder);this.clusterPolicyObjects.remove(builder);} return (T)this;
    }
    public ClusterPolicyObjectsNested<T> addNewClusterPolicyObject(){
    return new ClusterPolicyObjectsNested<T>();
    }
    public ClusterPolicyObjectsNested<T> addNewClusterPolicyObjectLike( ClusterPolicy item){
    return new ClusterPolicyObjectsNested<T>(item);
    }
    public T addToIdentityObjects( Identity ...items){
    for (Identity item : items) {IdentityBuilder builder = new IdentityBuilder(item);_visitables.add(builder);this.identityObjects.add(builder);} return (T)this;
    }
    public T removeFromIdentityObjects( Identity ...items){
    for (Identity item : items) {IdentityBuilder builder = new IdentityBuilder(item);_visitables.remove(builder);this.identityObjects.remove(builder);} return (T)this;
    }
    public IdentityObjectsNested<T> addNewIdentityObject(){
    return new IdentityObjectsNested<T>();
    }
    public IdentityObjectsNested<T> addNewIdentityObjectLike( Identity item){
    return new IdentityObjectsNested<T>(item);
    }
    public T addToNodeObjects( Node ...items){
    for (Node item : items) {NodeBuilder builder = new NodeBuilder(item);_visitables.add(builder);this.nodeObjects.add(builder);} return (T)this;
    }
    public T removeFromNodeObjects( Node ...items){
    for (Node item : items) {NodeBuilder builder = new NodeBuilder(item);_visitables.remove(builder);this.nodeObjects.remove(builder);} return (T)this;
    }
    public NodeObjectsNested<T> addNewNodeObject(){
    return new NodeObjectsNested<T>();
    }
    public NodeObjectsNested<T> addNewNodeObjectLike( Node item){
    return new NodeObjectsNested<T>(item);
    }
    public T addToSecretObjects( Secret ...items){
    for (Secret item : items) {SecretBuilder builder = new SecretBuilder(item);_visitables.add(builder);this.secretObjects.add(builder);} return (T)this;
    }
    public T removeFromSecretObjects( Secret ...items){
    for (Secret item : items) {SecretBuilder builder = new SecretBuilder(item);_visitables.remove(builder);this.secretObjects.remove(builder);} return (T)this;
    }
    public SecretObjectsNested<T> addNewSecretObject(){
    return new SecretObjectsNested<T>();
    }
    public SecretObjectsNested<T> addNewSecretObjectLike( Secret item){
    return new SecretObjectsNested<T>(item);
    }
    public T addToBuildObjects( Build ...items){
    for (Build item : items) {BuildBuilder builder = new BuildBuilder(item);_visitables.add(builder);this.buildObjects.add(builder);} return (T)this;
    }
    public T removeFromBuildObjects( Build ...items){
    for (Build item : items) {BuildBuilder builder = new BuildBuilder(item);_visitables.remove(builder);this.buildObjects.remove(builder);} return (T)this;
    }
    public BuildObjectsNested<T> addNewBuildObject(){
    return new BuildObjectsNested<T>();
    }
    public BuildObjectsNested<T> addNewBuildObjectLike( Build item){
    return new BuildObjectsNested<T>(item);
    }
    public T addToEndpointsObjects( Endpoints ...items){
    for (Endpoints item : items) {EndpointsBuilder builder = new EndpointsBuilder(item);_visitables.add(builder);this.endpointsObjects.add(builder);} return (T)this;
    }
    public T removeFromEndpointsObjects( Endpoints ...items){
    for (Endpoints item : items) {EndpointsBuilder builder = new EndpointsBuilder(item);_visitables.remove(builder);this.endpointsObjects.remove(builder);} return (T)this;
    }
    public EndpointsObjectsNested<T> addNewEndpointsObject(){
    return new EndpointsObjectsNested<T>();
    }
    public EndpointsObjectsNested<T> addNewEndpointsObjectLike( Endpoints item){
    return new EndpointsObjectsNested<T>(item);
    }
    public T addToRoleBindingObjects( RoleBinding ...items){
    for (RoleBinding item : items) {RoleBindingBuilder builder = new RoleBindingBuilder(item);_visitables.add(builder);this.roleBindingObjects.add(builder);} return (T)this;
    }
    public T removeFromRoleBindingObjects( RoleBinding ...items){
    for (RoleBinding item : items) {RoleBindingBuilder builder = new RoleBindingBuilder(item);_visitables.remove(builder);this.roleBindingObjects.remove(builder);} return (T)this;
    }
    public RoleBindingObjectsNested<T> addNewRoleBindingObject(){
    return new RoleBindingObjectsNested<T>();
    }
    public RoleBindingObjectsNested<T> addNewRoleBindingObjectLike( RoleBinding item){
    return new RoleBindingObjectsNested<T>(item);
    }
    public T addToBuildRequestObjects( BuildRequest ...items){
    for (BuildRequest item : items) {BuildRequestBuilder builder = new BuildRequestBuilder(item);_visitables.add(builder);this.buildRequestObjects.add(builder);} return (T)this;
    }
    public T removeFromBuildRequestObjects( BuildRequest ...items){
    for (BuildRequest item : items) {BuildRequestBuilder builder = new BuildRequestBuilder(item);_visitables.remove(builder);this.buildRequestObjects.remove(builder);} return (T)this;
    }
    public BuildRequestObjectsNested<T> addNewBuildRequestObject(){
    return new BuildRequestObjectsNested<T>();
    }
    public BuildRequestObjectsNested<T> addNewBuildRequestObjectLike( BuildRequest item){
    return new BuildRequestObjectsNested<T>(item);
    }
    public T addToPodObjects( Pod ...items){
    for (Pod item : items) {PodBuilder builder = new PodBuilder(item);_visitables.add(builder);this.podObjects.add(builder);} return (T)this;
    }
    public T removeFromPodObjects( Pod ...items){
    for (Pod item : items) {PodBuilder builder = new PodBuilder(item);_visitables.remove(builder);this.podObjects.remove(builder);} return (T)this;
    }
    public PodObjectsNested<T> addNewPodObject(){
    return new PodObjectsNested<T>();
    }
    public PodObjectsNested<T> addNewPodObjectLike( Pod item){
    return new PodObjectsNested<T>(item);
    }
    public T addToServiceObjects( Service ...items){
    for (Service item : items) {ServiceBuilder builder = new ServiceBuilder(item);_visitables.add(builder);this.serviceObjects.add(builder);} return (T)this;
    }
    public T removeFromServiceObjects( Service ...items){
    for (Service item : items) {ServiceBuilder builder = new ServiceBuilder(item);_visitables.remove(builder);this.serviceObjects.remove(builder);} return (T)this;
    }
    public ServiceObjectsNested<T> addNewServiceObject(){
    return new ServiceObjectsNested<T>();
    }
    public ServiceObjectsNested<T> addNewServiceObjectLike( Service item){
    return new ServiceObjectsNested<T>(item);
    }
    public T addToOAuthClientObjects( OAuthClient ...items){
    for (OAuthClient item : items) {OAuthClientBuilder builder = new OAuthClientBuilder(item);_visitables.add(builder);this.oAuthClientObjects.add(builder);} return (T)this;
    }
    public T removeFromOAuthClientObjects( OAuthClient ...items){
    for (OAuthClient item : items) {OAuthClientBuilder builder = new OAuthClientBuilder(item);_visitables.remove(builder);this.oAuthClientObjects.remove(builder);} return (T)this;
    }
    public OAuthClientObjectsNested<T> addNewOAuthClientObject(){
    return new OAuthClientObjectsNested<T>();
    }
    public OAuthClientObjectsNested<T> addNewOAuthClientObjectLike( OAuthClient item){
    return new OAuthClientObjectsNested<T>(item);
    }
    public T addToTemplateObjects( Template ...items){
    for (Template item : items) {TemplateBuilder builder = new TemplateBuilder(item);_visitables.add(builder);this.templateObjects.add(builder);} return (T)this;
    }
    public T removeFromTemplateObjects( Template ...items){
    for (Template item : items) {TemplateBuilder builder = new TemplateBuilder(item);_visitables.remove(builder);this.templateObjects.remove(builder);} return (T)this;
    }
    public TemplateObjectsNested<T> addNewTemplateObject(){
    return new TemplateObjectsNested<T>();
    }
    public TemplateObjectsNested<T> addNewTemplateObjectLike( Template item){
    return new TemplateObjectsNested<T>(item);
    }
    public T addToSecurityContextConstraintsObjects( SecurityContextConstraints ...items){
    for (SecurityContextConstraints item : items) {SecurityContextConstraintsBuilder builder = new SecurityContextConstraintsBuilder(item);_visitables.add(builder);this.securityContextConstraintsObjects.add(builder);} return (T)this;
    }
    public T removeFromSecurityContextConstraintsObjects( SecurityContextConstraints ...items){
    for (SecurityContextConstraints item : items) {SecurityContextConstraintsBuilder builder = new SecurityContextConstraintsBuilder(item);_visitables.remove(builder);this.securityContextConstraintsObjects.remove(builder);} return (T)this;
    }
    public SecurityContextConstraintsObjectsNested<T> addNewSecurityContextConstraintsObject(){
    return new SecurityContextConstraintsObjectsNested<T>();
    }
    public SecurityContextConstraintsObjectsNested<T> addNewSecurityContextConstraintsObjectLike( SecurityContextConstraints item){
    return new SecurityContextConstraintsObjectsNested<T>(item);
    }
    public T addToParameters( Parameter ...items){
    for (Parameter item : items) {ParameterBuilder builder = new ParameterBuilder(item);_visitables.add(builder);this.parameters.add(builder);} return (T)this;
    }
    public T removeFromParameters( Parameter ...items){
    for (Parameter item : items) {ParameterBuilder builder = new ParameterBuilder(item);_visitables.remove(builder);this.parameters.remove(builder);} return (T)this;
    }
    public List<Parameter> getParameters(){
    return build(parameters);
    }
    public T withParameters( List<Parameter> parameters){
    this.parameters.clear();if (parameters != null) {for (Parameter item : parameters){this.addToParameters(item);}} return (T) this;
    }
    public T withParameters( Parameter ...parameters){
    this.parameters.clear(); if (parameters != null) {for (Parameter item :parameters){ this.addToParameters(item);}} return (T) this;
    }
    public ParametersNested<T> addNewParameter(){
    return new ParametersNested<T>();
    }
    public ParametersNested<T> addNewParameterLike( Parameter item){
    return new ParametersNested<T>(item);
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
TemplateFluent that = (TemplateFluent) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (labels != null ? !labels.equals(that.labels) :that.labels != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (objects != null ? !objects.equals(that.objects) :that.objects != null) return false;
if (roleObjects != null ? !roleObjects.equals(that.roleObjects) :that.roleObjects != null) return false;
if (oAuthAccessTokenObjects != null ? !oAuthAccessTokenObjects.equals(that.oAuthAccessTokenObjects) :that.oAuthAccessTokenObjects != null) return false;
if (routeObjects != null ? !routeObjects.equals(that.routeObjects) :that.routeObjects != null) return false;
if (namespaceObjects != null ? !namespaceObjects.equals(that.namespaceObjects) :that.namespaceObjects != null) return false;
if (serviceAccountObjects != null ? !serviceAccountObjects.equals(that.serviceAccountObjects) :that.serviceAccountObjects != null) return false;
if (userObjects != null ? !userObjects.equals(that.userObjects) :that.userObjects != null) return false;
if (clusterRoleBindingObjects != null ? !clusterRoleBindingObjects.equals(that.clusterRoleBindingObjects) :that.clusterRoleBindingObjects != null) return false;
if (deploymentConfigObjects != null ? !deploymentConfigObjects.equals(that.deploymentConfigObjects) :that.deploymentConfigObjects != null) return false;
if (oAuthAuthorizeTokenObjects != null ? !oAuthAuthorizeTokenObjects.equals(that.oAuthAuthorizeTokenObjects) :that.oAuthAuthorizeTokenObjects != null) return false;
if (imageObjects != null ? !imageObjects.equals(that.imageObjects) :that.imageObjects != null) return false;
if (clusterRoleObjects != null ? !clusterRoleObjects.equals(that.clusterRoleObjects) :that.clusterRoleObjects != null) return false;
if (eventObjects != null ? !eventObjects.equals(that.eventObjects) :that.eventObjects != null) return false;
if (resourceQuotaObjects != null ? !resourceQuotaObjects.equals(that.resourceQuotaObjects) :that.resourceQuotaObjects != null) return false;
if (groupObjects != null ? !groupObjects.equals(that.groupObjects) :that.groupObjects != null) return false;
if (persistentVolumeClaimObjects != null ? !persistentVolumeClaimObjects.equals(that.persistentVolumeClaimObjects) :that.persistentVolumeClaimObjects != null) return false;
if (buildConfigObjects != null ? !buildConfigObjects.equals(that.buildConfigObjects) :that.buildConfigObjects != null) return false;
if (imageStreamObjects != null ? !imageStreamObjects.equals(that.imageStreamObjects) :that.imageStreamObjects != null) return false;
if (oAuthClientAuthorizationObjects != null ? !oAuthClientAuthorizationObjects.equals(that.oAuthClientAuthorizationObjects) :that.oAuthClientAuthorizationObjects != null) return false;
if (persistentVolumeObjects != null ? !persistentVolumeObjects.equals(that.persistentVolumeObjects) :that.persistentVolumeObjects != null) return false;
if (policyObjects != null ? !policyObjects.equals(that.policyObjects) :that.policyObjects != null) return false;
if (policyBindingObjects != null ? !policyBindingObjects.equals(that.policyBindingObjects) :that.policyBindingObjects != null) return false;
if (replicationControllerObjects != null ? !replicationControllerObjects.equals(that.replicationControllerObjects) :that.replicationControllerObjects != null) return false;
if (clusterPolicyBindingObjects != null ? !clusterPolicyBindingObjects.equals(that.clusterPolicyBindingObjects) :that.clusterPolicyBindingObjects != null) return false;
if (clusterPolicyObjects != null ? !clusterPolicyObjects.equals(that.clusterPolicyObjects) :that.clusterPolicyObjects != null) return false;
if (identityObjects != null ? !identityObjects.equals(that.identityObjects) :that.identityObjects != null) return false;
if (nodeObjects != null ? !nodeObjects.equals(that.nodeObjects) :that.nodeObjects != null) return false;
if (secretObjects != null ? !secretObjects.equals(that.secretObjects) :that.secretObjects != null) return false;
if (buildObjects != null ? !buildObjects.equals(that.buildObjects) :that.buildObjects != null) return false;
if (endpointsObjects != null ? !endpointsObjects.equals(that.endpointsObjects) :that.endpointsObjects != null) return false;
if (roleBindingObjects != null ? !roleBindingObjects.equals(that.roleBindingObjects) :that.roleBindingObjects != null) return false;
if (buildRequestObjects != null ? !buildRequestObjects.equals(that.buildRequestObjects) :that.buildRequestObjects != null) return false;
if (podObjects != null ? !podObjects.equals(that.podObjects) :that.podObjects != null) return false;
if (serviceObjects != null ? !serviceObjects.equals(that.serviceObjects) :that.serviceObjects != null) return false;
if (oAuthClientObjects != null ? !oAuthClientObjects.equals(that.oAuthClientObjects) :that.oAuthClientObjects != null) return false;
if (templateObjects != null ? !templateObjects.equals(that.templateObjects) :that.templateObjects != null) return false;
if (securityContextConstraintsObjects != null ? !securityContextConstraintsObjects.equals(that.securityContextConstraintsObjects) :that.securityContextConstraintsObjects != null) return false;
if (parameters != null ? !parameters.equals(that.parameters) :that.parameters != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNested (){
        this.builder = new ObjectMetaBuilder(this);
        }
             MetadataNested ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
    
            public N and(){
            return (N) TemplateFluent.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}
    public class RoleObjectsNested<N> extends RoleFluent<RoleObjectsNested<N>> implements Nested<N>{

        private final RoleBuilder builder;
    
             RoleObjectsNested (){
        this.builder = new RoleBuilder(this);
        }
             RoleObjectsNested ( Role item){
        this.builder = new RoleBuilder(this, item);
        }
    
            public N and(){
            return (N) TemplateFluent.this.addToRoleObjects(builder.build());
        }
            public N endRoleObject(){
            return and();
        }
    
}
    public class OAuthAccessTokenObjectsNested<N> extends OAuthAccessTokenFluent<OAuthAccessTokenObjectsNested<N>> implements Nested<N>{

        private final OAuthAccessTokenBuilder builder;
    
             OAuthAccessTokenObjectsNested (){
        this.builder = new OAuthAccessTokenBuilder(this);
        }
             OAuthAccessTokenObjectsNested ( OAuthAccessToken item){
        this.builder = new OAuthAccessTokenBuilder(this, item);
        }
    
            public N endOAuthAccessTokenObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToOAuthAccessTokenObjects(builder.build());
        }
    
}
    public class RouteObjectsNested<N> extends RouteFluent<RouteObjectsNested<N>> implements Nested<N>{

        private final RouteBuilder builder;
    
             RouteObjectsNested (){
        this.builder = new RouteBuilder(this);
        }
             RouteObjectsNested ( Route item){
        this.builder = new RouteBuilder(this, item);
        }
    
            public N endRouteObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToRouteObjects(builder.build());
        }
    
}
    public class NamespaceObjectsNested<N> extends NamespaceFluent<NamespaceObjectsNested<N>> implements Nested<N>{

        private final NamespaceBuilder builder;
    
             NamespaceObjectsNested (){
        this.builder = new NamespaceBuilder(this);
        }
             NamespaceObjectsNested ( Namespace item){
        this.builder = new NamespaceBuilder(this, item);
        }
    
            public N endNamespaceObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToNamespaceObjects(builder.build());
        }
    
}
    public class ServiceAccountObjectsNested<N> extends ServiceAccountFluent<ServiceAccountObjectsNested<N>> implements Nested<N>{

        private final ServiceAccountBuilder builder;
    
             ServiceAccountObjectsNested (){
        this.builder = new ServiceAccountBuilder(this);
        }
             ServiceAccountObjectsNested ( ServiceAccount item){
        this.builder = new ServiceAccountBuilder(this, item);
        }
    
            public N and(){
            return (N) TemplateFluent.this.addToServiceAccountObjects(builder.build());
        }
            public N endServiceAccountObject(){
            return and();
        }
    
}
    public class UserObjectsNested<N> extends UserFluent<UserObjectsNested<N>> implements Nested<N>{

        private final UserBuilder builder;
    
             UserObjectsNested (){
        this.builder = new UserBuilder(this);
        }
             UserObjectsNested ( User item){
        this.builder = new UserBuilder(this, item);
        }
    
            public N and(){
            return (N) TemplateFluent.this.addToUserObjects(builder.build());
        }
            public N endUserObject(){
            return and();
        }
    
}
    public class ClusterRoleBindingObjectsNested<N> extends ClusterRoleBindingFluent<ClusterRoleBindingObjectsNested<N>> implements Nested<N>{

        private final ClusterRoleBindingBuilder builder;
    
             ClusterRoleBindingObjectsNested (){
        this.builder = new ClusterRoleBindingBuilder(this);
        }
             ClusterRoleBindingObjectsNested ( ClusterRoleBinding item){
        this.builder = new ClusterRoleBindingBuilder(this, item);
        }
    
            public N endClusterRoleBindingObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToClusterRoleBindingObjects(builder.build());
        }
    
}
    public class DeploymentConfigObjectsNested<N> extends DeploymentConfigFluent<DeploymentConfigObjectsNested<N>> implements Nested<N>{

        private final DeploymentConfigBuilder builder;
    
             DeploymentConfigObjectsNested (){
        this.builder = new DeploymentConfigBuilder(this);
        }
             DeploymentConfigObjectsNested ( DeploymentConfig item){
        this.builder = new DeploymentConfigBuilder(this, item);
        }
    
            public N and(){
            return (N) TemplateFluent.this.addToDeploymentConfigObjects(builder.build());
        }
            public N endDeploymentConfigObject(){
            return and();
        }
    
}
    public class OAuthAuthorizeTokenObjectsNested<N> extends OAuthAuthorizeTokenFluent<OAuthAuthorizeTokenObjectsNested<N>> implements Nested<N>{

        private final OAuthAuthorizeTokenBuilder builder;
    
             OAuthAuthorizeTokenObjectsNested (){
        this.builder = new OAuthAuthorizeTokenBuilder(this);
        }
             OAuthAuthorizeTokenObjectsNested ( OAuthAuthorizeToken item){
        this.builder = new OAuthAuthorizeTokenBuilder(this, item);
        }
    
            public N and(){
            return (N) TemplateFluent.this.addToOAuthAuthorizeTokenObjects(builder.build());
        }
            public N endOAuthAuthorizeTokenObject(){
            return and();
        }
    
}
    public class ImageObjectsNested<N> extends ImageFluent<ImageObjectsNested<N>> implements Nested<N>{

        private final ImageBuilder builder;
    
             ImageObjectsNested ( Image item){
        this.builder = new ImageBuilder(this, item);
        }
             ImageObjectsNested (){
        this.builder = new ImageBuilder(this);
        }
    
            public N endImageObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToImageObjects(builder.build());
        }
    
}
    public class ClusterRoleObjectsNested<N> extends ClusterRoleFluent<ClusterRoleObjectsNested<N>> implements Nested<N>{

        private final ClusterRoleBuilder builder;
    
             ClusterRoleObjectsNested (){
        this.builder = new ClusterRoleBuilder(this);
        }
             ClusterRoleObjectsNested ( ClusterRole item){
        this.builder = new ClusterRoleBuilder(this, item);
        }
    
            public N endClusterRoleObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToClusterRoleObjects(builder.build());
        }
    
}
    public class EventObjectsNested<N> extends EventFluent<EventObjectsNested<N>> implements Nested<N>{

        private final EventBuilder builder;
    
             EventObjectsNested ( Event item){
        this.builder = new EventBuilder(this, item);
        }
             EventObjectsNested (){
        this.builder = new EventBuilder(this);
        }
    
            public N and(){
            return (N) TemplateFluent.this.addToEventObjects(builder.build());
        }
            public N endEventObject(){
            return and();
        }
    
}
    public class ResourceQuotaObjectsNested<N> extends ResourceQuotaFluent<ResourceQuotaObjectsNested<N>> implements Nested<N>{

        private final ResourceQuotaBuilder builder;
    
             ResourceQuotaObjectsNested (){
        this.builder = new ResourceQuotaBuilder(this);
        }
             ResourceQuotaObjectsNested ( ResourceQuota item){
        this.builder = new ResourceQuotaBuilder(this, item);
        }
    
            public N endResourceQuotaObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToResourceQuotaObjects(builder.build());
        }
    
}
    public class GroupObjectsNested<N> extends GroupFluent<GroupObjectsNested<N>> implements Nested<N>{

        private final GroupBuilder builder;
    
             GroupObjectsNested (){
        this.builder = new GroupBuilder(this);
        }
             GroupObjectsNested ( Group item){
        this.builder = new GroupBuilder(this, item);
        }
    
            public N and(){
            return (N) TemplateFluent.this.addToGroupObjects(builder.build());
        }
            public N endGroupObject(){
            return and();
        }
    
}
    public class PersistentVolumeClaimObjectsNested<N> extends PersistentVolumeClaimFluent<PersistentVolumeClaimObjectsNested<N>> implements Nested<N>{

        private final PersistentVolumeClaimBuilder builder;
    
             PersistentVolumeClaimObjectsNested (){
        this.builder = new PersistentVolumeClaimBuilder(this);
        }
             PersistentVolumeClaimObjectsNested ( PersistentVolumeClaim item){
        this.builder = new PersistentVolumeClaimBuilder(this, item);
        }
    
            public N endPersistentVolumeClaimObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToPersistentVolumeClaimObjects(builder.build());
        }
    
}
    public class BuildConfigObjectsNested<N> extends BuildConfigFluent<BuildConfigObjectsNested<N>> implements Nested<N>{

        private final BuildConfigBuilder builder;
    
             BuildConfigObjectsNested (){
        this.builder = new BuildConfigBuilder(this);
        }
             BuildConfigObjectsNested ( BuildConfig item){
        this.builder = new BuildConfigBuilder(this, item);
        }
    
            public N and(){
            return (N) TemplateFluent.this.addToBuildConfigObjects(builder.build());
        }
            public N endBuildConfigObject(){
            return and();
        }
    
}
    public class ImageStreamObjectsNested<N> extends ImageStreamFluent<ImageStreamObjectsNested<N>> implements Nested<N>{

        private final ImageStreamBuilder builder;
    
             ImageStreamObjectsNested (){
        this.builder = new ImageStreamBuilder(this);
        }
             ImageStreamObjectsNested ( ImageStream item){
        this.builder = new ImageStreamBuilder(this, item);
        }
    
            public N endImageStreamObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToImageStreamObjects(builder.build());
        }
    
}
    public class OAuthClientAuthorizationObjectsNested<N> extends OAuthClientAuthorizationFluent<OAuthClientAuthorizationObjectsNested<N>> implements Nested<N>{

        private final OAuthClientAuthorizationBuilder builder;
    
             OAuthClientAuthorizationObjectsNested (){
        this.builder = new OAuthClientAuthorizationBuilder(this);
        }
             OAuthClientAuthorizationObjectsNested ( OAuthClientAuthorization item){
        this.builder = new OAuthClientAuthorizationBuilder(this, item);
        }
    
            public N endOAuthClientAuthorizationObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToOAuthClientAuthorizationObjects(builder.build());
        }
    
}
    public class PersistentVolumeObjectsNested<N> extends PersistentVolumeFluent<PersistentVolumeObjectsNested<N>> implements Nested<N>{

        private final PersistentVolumeBuilder builder;
    
             PersistentVolumeObjectsNested (){
        this.builder = new PersistentVolumeBuilder(this);
        }
             PersistentVolumeObjectsNested ( PersistentVolume item){
        this.builder = new PersistentVolumeBuilder(this, item);
        }
    
            public N and(){
            return (N) TemplateFluent.this.addToPersistentVolumeObjects(builder.build());
        }
            public N endPersistentVolumeObject(){
            return and();
        }
    
}
    public class PolicyObjectsNested<N> extends PolicyFluent<PolicyObjectsNested<N>> implements Nested<N>{

        private final PolicyBuilder builder;
    
             PolicyObjectsNested (){
        this.builder = new PolicyBuilder(this);
        }
             PolicyObjectsNested ( Policy item){
        this.builder = new PolicyBuilder(this, item);
        }
    
            public N and(){
            return (N) TemplateFluent.this.addToPolicyObjects(builder.build());
        }
            public N endPolicyObject(){
            return and();
        }
    
}
    public class PolicyBindingObjectsNested<N> extends PolicyBindingFluent<PolicyBindingObjectsNested<N>> implements Nested<N>{

        private final PolicyBindingBuilder builder;
    
             PolicyBindingObjectsNested (){
        this.builder = new PolicyBindingBuilder(this);
        }
             PolicyBindingObjectsNested ( PolicyBinding item){
        this.builder = new PolicyBindingBuilder(this, item);
        }
    
            public N and(){
            return (N) TemplateFluent.this.addToPolicyBindingObjects(builder.build());
        }
            public N endPolicyBindingObject(){
            return and();
        }
    
}
    public class ReplicationControllerObjectsNested<N> extends ReplicationControllerFluent<ReplicationControllerObjectsNested<N>> implements Nested<N>{

        private final ReplicationControllerBuilder builder;
    
             ReplicationControllerObjectsNested (){
        this.builder = new ReplicationControllerBuilder(this);
        }
             ReplicationControllerObjectsNested ( ReplicationController item){
        this.builder = new ReplicationControllerBuilder(this, item);
        }
    
            public N endReplicationControllerObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToReplicationControllerObjects(builder.build());
        }
    
}
    public class ClusterPolicyBindingObjectsNested<N> extends ClusterPolicyBindingFluent<ClusterPolicyBindingObjectsNested<N>> implements Nested<N>{

        private final ClusterPolicyBindingBuilder builder;
    
             ClusterPolicyBindingObjectsNested (){
        this.builder = new ClusterPolicyBindingBuilder(this);
        }
             ClusterPolicyBindingObjectsNested ( ClusterPolicyBinding item){
        this.builder = new ClusterPolicyBindingBuilder(this, item);
        }
    
            public N endClusterPolicyBindingObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToClusterPolicyBindingObjects(builder.build());
        }
    
}
    public class ClusterPolicyObjectsNested<N> extends ClusterPolicyFluent<ClusterPolicyObjectsNested<N>> implements Nested<N>{

        private final ClusterPolicyBuilder builder;
    
             ClusterPolicyObjectsNested (){
        this.builder = new ClusterPolicyBuilder(this);
        }
             ClusterPolicyObjectsNested ( ClusterPolicy item){
        this.builder = new ClusterPolicyBuilder(this, item);
        }
    
            public N endClusterPolicyObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToClusterPolicyObjects(builder.build());
        }
    
}
    public class IdentityObjectsNested<N> extends IdentityFluent<IdentityObjectsNested<N>> implements Nested<N>{

        private final IdentityBuilder builder;
    
             IdentityObjectsNested (){
        this.builder = new IdentityBuilder(this);
        }
             IdentityObjectsNested ( Identity item){
        this.builder = new IdentityBuilder(this, item);
        }
    
            public N and(){
            return (N) TemplateFluent.this.addToIdentityObjects(builder.build());
        }
            public N endIdentityObject(){
            return and();
        }
    
}
    public class NodeObjectsNested<N> extends NodeFluent<NodeObjectsNested<N>> implements Nested<N>{

        private final NodeBuilder builder;
    
             NodeObjectsNested (){
        this.builder = new NodeBuilder(this);
        }
             NodeObjectsNested ( Node item){
        this.builder = new NodeBuilder(this, item);
        }
    
            public N endNodeObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToNodeObjects(builder.build());
        }
    
}
    public class SecretObjectsNested<N> extends SecretFluent<SecretObjectsNested<N>> implements Nested<N>{

        private final SecretBuilder builder;
    
             SecretObjectsNested (){
        this.builder = new SecretBuilder(this);
        }
             SecretObjectsNested ( Secret item){
        this.builder = new SecretBuilder(this, item);
        }
    
            public N endSecretObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToSecretObjects(builder.build());
        }
    
}
    public class BuildObjectsNested<N> extends BuildFluent<BuildObjectsNested<N>> implements Nested<N>{

        private final BuildBuilder builder;
    
             BuildObjectsNested (){
        this.builder = new BuildBuilder(this);
        }
             BuildObjectsNested ( Build item){
        this.builder = new BuildBuilder(this, item);
        }
    
            public N endBuildObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToBuildObjects(builder.build());
        }
    
}
    public class EndpointsObjectsNested<N> extends EndpointsFluent<EndpointsObjectsNested<N>> implements Nested<N>{

        private final EndpointsBuilder builder;
    
             EndpointsObjectsNested (){
        this.builder = new EndpointsBuilder(this);
        }
             EndpointsObjectsNested ( Endpoints item){
        this.builder = new EndpointsBuilder(this, item);
        }
    
            public N and(){
            return (N) TemplateFluent.this.addToEndpointsObjects(builder.build());
        }
            public N endEndpointsObject(){
            return and();
        }
    
}
    public class RoleBindingObjectsNested<N> extends RoleBindingFluent<RoleBindingObjectsNested<N>> implements Nested<N>{

        private final RoleBindingBuilder builder;
    
             RoleBindingObjectsNested (){
        this.builder = new RoleBindingBuilder(this);
        }
             RoleBindingObjectsNested ( RoleBinding item){
        this.builder = new RoleBindingBuilder(this, item);
        }
    
            public N and(){
            return (N) TemplateFluent.this.addToRoleBindingObjects(builder.build());
        }
            public N endRoleBindingObject(){
            return and();
        }
    
}
    public class BuildRequestObjectsNested<N> extends BuildRequestFluent<BuildRequestObjectsNested<N>> implements Nested<N>{

        private final BuildRequestBuilder builder;
    
             BuildRequestObjectsNested (){
        this.builder = new BuildRequestBuilder(this);
        }
             BuildRequestObjectsNested ( BuildRequest item){
        this.builder = new BuildRequestBuilder(this, item);
        }
    
            public N endBuildRequestObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToBuildRequestObjects(builder.build());
        }
    
}
    public class PodObjectsNested<N> extends PodFluent<PodObjectsNested<N>> implements Nested<N>{

        private final PodBuilder builder;
    
             PodObjectsNested (){
        this.builder = new PodBuilder(this);
        }
             PodObjectsNested ( Pod item){
        this.builder = new PodBuilder(this, item);
        }
    
            public N endPodObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToPodObjects(builder.build());
        }
    
}
    public class ServiceObjectsNested<N> extends ServiceFluent<ServiceObjectsNested<N>> implements Nested<N>{

        private final ServiceBuilder builder;
    
             ServiceObjectsNested (){
        this.builder = new ServiceBuilder(this);
        }
             ServiceObjectsNested ( Service item){
        this.builder = new ServiceBuilder(this, item);
        }
    
            public N and(){
            return (N) TemplateFluent.this.addToServiceObjects(builder.build());
        }
            public N endServiceObject(){
            return and();
        }
    
}
    public class OAuthClientObjectsNested<N> extends OAuthClientFluent<OAuthClientObjectsNested<N>> implements Nested<N>{

        private final OAuthClientBuilder builder;
    
             OAuthClientObjectsNested ( OAuthClient item){
        this.builder = new OAuthClientBuilder(this, item);
        }
             OAuthClientObjectsNested (){
        this.builder = new OAuthClientBuilder(this);
        }
    
            public N and(){
            return (N) TemplateFluent.this.addToOAuthClientObjects(builder.build());
        }
            public N endOAuthClientObject(){
            return and();
        }
    
}
    public class TemplateObjectsNested<N> extends TemplateFluent<TemplateObjectsNested<N>> implements Nested<N>{

        private final TemplateBuilder builder;
    
             TemplateObjectsNested (){
        this.builder = new TemplateBuilder(this);
        }
             TemplateObjectsNested ( Template item){
        this.builder = new TemplateBuilder(this, item);
        }
    
            public N endTemplateObject(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToTemplateObjects(builder.build());
        }
    
}
    public class SecurityContextConstraintsObjectsNested<N> extends SecurityContextConstraintsFluent<SecurityContextConstraintsObjectsNested<N>> implements Nested<N>{

        private final SecurityContextConstraintsBuilder builder;
    
             SecurityContextConstraintsObjectsNested (){
        this.builder = new SecurityContextConstraintsBuilder(this);
        }
             SecurityContextConstraintsObjectsNested ( SecurityContextConstraints item){
        this.builder = new SecurityContextConstraintsBuilder(this, item);
        }
    
            public N and(){
            return (N) TemplateFluent.this.addToSecurityContextConstraintsObjects(builder.build());
        }
            public N endSecurityContextConstraintsObject(){
            return and();
        }
    
}
    public class ParametersNested<N> extends ParameterFluent<ParametersNested<N>> implements Nested<N>{

        private final ParameterBuilder builder;
    
             ParametersNested (){
        this.builder = new ParameterBuilder(this);
        }
             ParametersNested ( Parameter item){
        this.builder = new ParameterBuilder(this, item);
        }
    
            public N endParameter(){
            return and();
        }
            public N and(){
            return (N) TemplateFluent.this.addToParameters(builder.build());
        }
    
}


}
