package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class ContainerStateBuilder extends ContainerStateFluent<ContainerStateBuilder> implements VisitableBuilder<ContainerState,ContainerStateBuilder>{

     ContainerStateFluent<?> fluent;
public ContainerStateBuilder(){
    this(new ContainerState());
}
public ContainerStateBuilder( ContainerStateFluent<?> fluent ){
    this(fluent, new ContainerState());
}
public ContainerStateBuilder( ContainerStateFluent<?> fluent , ContainerState instance ){
    this.fluent = fluent; fluent.withRunning(instance.getRunning()); fluent.withTerminated(instance.getTerminated()); fluent.withWaiting(instance.getWaiting()); 
}
public ContainerStateBuilder( ContainerState instance ){
    this.fluent = this; this.withRunning(instance.getRunning()); this.withTerminated(instance.getTerminated()); this.withWaiting(instance.getWaiting()); 
}

public EditableContainerState build(){
    EditableContainerState buildable = new EditableContainerState(fluent.getRunning(),fluent.getTerminated(),fluent.getWaiting());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
ContainerStateBuilder that = (ContainerStateBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    