package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public class ServiceStatusFluent<T extends ServiceStatusFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     VisitableBuilder<LoadBalancerStatus, ?> loadBalancer;     Map<String, Object> additionalProperties = new HashMap();

    public LoadBalancerStatus getLoadBalancer(){
    return this.loadBalancer!=null?this.loadBalancer.build():null;
    }
    public T withLoadBalancer( LoadBalancerStatus loadBalancer){
    if (loadBalancer!=null){ this.loadBalancer= new LoadBalancerStatusBuilder(loadBalancer); _visitables.add(this.loadBalancer);} return (T) this;
    }
    public LoadBalancerNested<T> withNewLoadBalancer(){
    return new LoadBalancerNested<T>();
    }
    public LoadBalancerNested<T> withNewLoadBalancerLike( LoadBalancerStatus item){
    return new LoadBalancerNested<T>(item);
    }
    public LoadBalancerNested<T> editLoadBalancer(){
    return withNewLoadBalancerLike(getLoadBalancer());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ServiceStatusFluent that = (ServiceStatusFluent) o;
if (loadBalancer != null ? !loadBalancer.equals(that.loadBalancer) :that.loadBalancer != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class LoadBalancerNested<N> extends LoadBalancerStatusFluent<LoadBalancerNested<N>> implements Nested<N>{

        private final LoadBalancerStatusBuilder builder;
    
             LoadBalancerNested ( LoadBalancerStatus item){
        this.builder = new LoadBalancerStatusBuilder(this, item);
        }
             LoadBalancerNested (){
        this.builder = new LoadBalancerStatusBuilder(this);
        }
    
            public N and(){
            return (N) ServiceStatusFluent.this.withLoadBalancer(builder.build());
        }
            public N endLoadBalancer(){
            return and();
        }
    
}


}
