package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class BuildConfigSpecFluent<T extends BuildConfigSpecFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     VisitableBuilder<BuildOutput, ?> output;     VisitableBuilder<ResourceRequirements, ?> resources;     VisitableBuilder<SourceRevision, ?> revision;     String serviceAccount;     VisitableBuilder<BuildSource, ?> source;     VisitableBuilder<BuildStrategy, ?> strategy;     List<VisitableBuilder<BuildTriggerPolicy, ?>> triggers = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();

    public BuildOutput getOutput(){
    return this.output!=null?this.output.build():null;
    }
    public T withOutput( BuildOutput output){
    if (output!=null){ this.output= new BuildOutputBuilder(output); _visitables.add(this.output);} return (T) this;
    }
    public OutputNested<T> withNewOutput(){
    return new OutputNested<T>();
    }
    public OutputNested<T> withNewOutputLike( BuildOutput item){
    return new OutputNested<T>(item);
    }
    public OutputNested<T> editOutput(){
    return withNewOutputLike(getOutput());
    }
    public ResourceRequirements getResources(){
    return this.resources!=null?this.resources.build():null;
    }
    public T withResources( ResourceRequirements resources){
    if (resources!=null){ this.resources= new ResourceRequirementsBuilder(resources); _visitables.add(this.resources);} return (T) this;
    }
    public ResourcesNested<T> withNewResources(){
    return new ResourcesNested<T>();
    }
    public ResourcesNested<T> withNewResourcesLike( ResourceRequirements item){
    return new ResourcesNested<T>(item);
    }
    public ResourcesNested<T> editResources(){
    return withNewResourcesLike(getResources());
    }
    public SourceRevision getRevision(){
    return this.revision!=null?this.revision.build():null;
    }
    public T withRevision( SourceRevision revision){
    if (revision!=null){ this.revision= new SourceRevisionBuilder(revision); _visitables.add(this.revision);} return (T) this;
    }
    public RevisionNested<T> withNewRevision(){
    return new RevisionNested<T>();
    }
    public RevisionNested<T> withNewRevisionLike( SourceRevision item){
    return new RevisionNested<T>(item);
    }
    public RevisionNested<T> editRevision(){
    return withNewRevisionLike(getRevision());
    }
    public String getServiceAccount(){
    return this.serviceAccount;
    }
    public T withServiceAccount( String serviceAccount){
    this.serviceAccount=serviceAccount; return (T) this;
    }
    public BuildSource getSource(){
    return this.source!=null?this.source.build():null;
    }
    public T withSource( BuildSource source){
    if (source!=null){ this.source= new BuildSourceBuilder(source); _visitables.add(this.source);} return (T) this;
    }
    public SourceNested<T> withNewSource(){
    return new SourceNested<T>();
    }
    public SourceNested<T> withNewSourceLike( BuildSource item){
    return new SourceNested<T>(item);
    }
    public SourceNested<T> editSource(){
    return withNewSourceLike(getSource());
    }
    public BuildStrategy getStrategy(){
    return this.strategy!=null?this.strategy.build():null;
    }
    public T withStrategy( BuildStrategy strategy){
    if (strategy!=null){ this.strategy= new BuildStrategyBuilder(strategy); _visitables.add(this.strategy);} return (T) this;
    }
    public StrategyNested<T> withNewStrategy(){
    return new StrategyNested<T>();
    }
    public StrategyNested<T> withNewStrategyLike( BuildStrategy item){
    return new StrategyNested<T>(item);
    }
    public StrategyNested<T> editStrategy(){
    return withNewStrategyLike(getStrategy());
    }
    public T addToTriggers( BuildTriggerPolicy ...items){
    for (BuildTriggerPolicy item : items) {BuildTriggerPolicyBuilder builder = new BuildTriggerPolicyBuilder(item);_visitables.add(builder);this.triggers.add(builder);} return (T)this;
    }
    public T removeFromTriggers( BuildTriggerPolicy ...items){
    for (BuildTriggerPolicy item : items) {BuildTriggerPolicyBuilder builder = new BuildTriggerPolicyBuilder(item);_visitables.remove(builder);this.triggers.remove(builder);} return (T)this;
    }
    public List<BuildTriggerPolicy> getTriggers(){
    return build(triggers);
    }
    public T withTriggers( List<BuildTriggerPolicy> triggers){
    this.triggers.clear();if (triggers != null) {for (BuildTriggerPolicy item : triggers){this.addToTriggers(item);}} return (T) this;
    }
    public T withTriggers( BuildTriggerPolicy ...triggers){
    this.triggers.clear(); if (triggers != null) {for (BuildTriggerPolicy item :triggers){ this.addToTriggers(item);}} return (T) this;
    }
    public TriggersNested<T> addNewTrigger(){
    return new TriggersNested<T>();
    }
    public TriggersNested<T> addNewTriggerLike( BuildTriggerPolicy item){
    return new TriggersNested<T>(item);
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
BuildConfigSpecFluent that = (BuildConfigSpecFluent) o;
if (output != null ? !output.equals(that.output) :that.output != null) return false;
if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
if (revision != null ? !revision.equals(that.revision) :that.revision != null) return false;
if (serviceAccount != null ? !serviceAccount.equals(that.serviceAccount) :that.serviceAccount != null) return false;
if (source != null ? !source.equals(that.source) :that.source != null) return false;
if (strategy != null ? !strategy.equals(that.strategy) :that.strategy != null) return false;
if (triggers != null ? !triggers.equals(that.triggers) :that.triggers != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class OutputNested<N> extends BuildOutputFluent<OutputNested<N>> implements Nested<N>{

        private final BuildOutputBuilder builder;
    
             OutputNested (){
        this.builder = new BuildOutputBuilder(this);
        }
             OutputNested ( BuildOutput item){
        this.builder = new BuildOutputBuilder(this, item);
        }
    
            public N endOutput(){
            return and();
        }
            public N and(){
            return (N) BuildConfigSpecFluent.this.withOutput(builder.build());
        }
    
}
    public class ResourcesNested<N> extends ResourceRequirementsFluent<ResourcesNested<N>> implements Nested<N>{

        private final ResourceRequirementsBuilder builder;
    
             ResourcesNested (){
        this.builder = new ResourceRequirementsBuilder(this);
        }
             ResourcesNested ( ResourceRequirements item){
        this.builder = new ResourceRequirementsBuilder(this, item);
        }
    
            public N and(){
            return (N) BuildConfigSpecFluent.this.withResources(builder.build());
        }
            public N endResources(){
            return and();
        }
    
}
    public class RevisionNested<N> extends SourceRevisionFluent<RevisionNested<N>> implements Nested<N>{

        private final SourceRevisionBuilder builder;
    
             RevisionNested ( SourceRevision item){
        this.builder = new SourceRevisionBuilder(this, item);
        }
             RevisionNested (){
        this.builder = new SourceRevisionBuilder(this);
        }
    
            public N endRevision(){
            return and();
        }
            public N and(){
            return (N) BuildConfigSpecFluent.this.withRevision(builder.build());
        }
    
}
    public class SourceNested<N> extends BuildSourceFluent<SourceNested<N>> implements Nested<N>{

        private final BuildSourceBuilder builder;
    
             SourceNested (){
        this.builder = new BuildSourceBuilder(this);
        }
             SourceNested ( BuildSource item){
        this.builder = new BuildSourceBuilder(this, item);
        }
    
            public N and(){
            return (N) BuildConfigSpecFluent.this.withSource(builder.build());
        }
            public N endSource(){
            return and();
        }
    
}
    public class StrategyNested<N> extends BuildStrategyFluent<StrategyNested<N>> implements Nested<N>{

        private final BuildStrategyBuilder builder;
    
             StrategyNested ( BuildStrategy item){
        this.builder = new BuildStrategyBuilder(this, item);
        }
             StrategyNested (){
        this.builder = new BuildStrategyBuilder(this);
        }
    
            public N endStrategy(){
            return and();
        }
            public N and(){
            return (N) BuildConfigSpecFluent.this.withStrategy(builder.build());
        }
    
}
    public class TriggersNested<N> extends BuildTriggerPolicyFluent<TriggersNested<N>> implements Nested<N>{

        private final BuildTriggerPolicyBuilder builder;
    
             TriggersNested (){
        this.builder = new BuildTriggerPolicyBuilder(this);
        }
             TriggersNested ( BuildTriggerPolicy item){
        this.builder = new BuildTriggerPolicyBuilder(this, item);
        }
    
            public N endTrigger(){
            return and();
        }
            public N and(){
            return (N) BuildConfigSpecFluent.this.addToTriggers(builder.build());
        }
    
}


}
