package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class SecurityContextBuilder extends SecurityContextFluent<SecurityContextBuilder> implements VisitableBuilder<SecurityContext,SecurityContextBuilder>{

     SecurityContextFluent<?> fluent;
public SecurityContextBuilder(){
    this(new SecurityContext());
}
public SecurityContextBuilder( SecurityContextFluent<?> fluent ){
    this(fluent, new SecurityContext());
}
public SecurityContextBuilder( SecurityContextFluent<?> fluent , SecurityContext instance ){
    this.fluent = fluent; fluent.withCapabilities(instance.getCapabilities()); fluent.withPrivileged(instance.getPrivileged()); fluent.withRunAsNonRoot(instance.getRunAsNonRoot()); fluent.withRunAsUser(instance.getRunAsUser()); fluent.withSeLinuxOptions(instance.getSeLinuxOptions()); 
}
public SecurityContextBuilder( SecurityContext instance ){
    this.fluent = this; this.withCapabilities(instance.getCapabilities()); this.withPrivileged(instance.getPrivileged()); this.withRunAsNonRoot(instance.getRunAsNonRoot()); this.withRunAsUser(instance.getRunAsUser()); this.withSeLinuxOptions(instance.getSeLinuxOptions()); 
}

public EditableSecurityContext build(){
    EditableSecurityContext buildable = new EditableSecurityContext(fluent.getCapabilities(),fluent.isPrivileged(),fluent.isRunAsNonRoot(),fluent.getRunAsUser(),fluent.getSeLinuxOptions());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
SecurityContextBuilder that = (SecurityContextBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    