package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class PersistentVolumeFluent<T extends PersistentVolumeFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     PersistentVolume.ApiVersion apiVersion;     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     VisitableBuilder<PersistentVolumeSpec, ?> spec;     VisitableBuilder<PersistentVolumeStatus, ?> status;     Map<String, Object> additionalProperties = new HashMap();

    public PersistentVolume.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( PersistentVolume.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNested<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ObjectMeta item){
    return new MetadataNested<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public PersistentVolumeSpec getSpec(){
    return this.spec!=null?this.spec.build():null;
    }
    public T withSpec( PersistentVolumeSpec spec){
    if (spec!=null){ this.spec= new PersistentVolumeSpecBuilder(spec); _visitables.add(this.spec);} return (T) this;
    }
    public SpecNested<T> withNewSpec(){
    return new SpecNested<T>();
    }
    public SpecNested<T> withNewSpecLike( PersistentVolumeSpec item){
    return new SpecNested<T>(item);
    }
    public SpecNested<T> editSpec(){
    return withNewSpecLike(getSpec());
    }
    public PersistentVolumeStatus getStatus(){
    return this.status!=null?this.status.build():null;
    }
    public T withStatus( PersistentVolumeStatus status){
    if (status!=null){ this.status= new PersistentVolumeStatusBuilder(status); _visitables.add(this.status);} return (T) this;
    }
    public StatusNested<T> withNewStatus(){
    return new StatusNested<T>();
    }
    public StatusNested<T> withNewStatusLike( PersistentVolumeStatus item){
    return new StatusNested<T>(item);
    }
    public StatusNested<T> editStatus(){
    return withNewStatusLike(getStatus());
    }
    public T withNewStatus( String message,  String phase,  String reason){
    return withStatus(new PersistentVolumeStatus(message, phase, reason));
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
PersistentVolumeFluent that = (PersistentVolumeFluent) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
if (status != null ? !status.equals(that.status) :that.status != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNested (){
        this.builder = new ObjectMetaBuilder(this);
        }
             MetadataNested ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
    
            public N and(){
            return (N) PersistentVolumeFluent.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}
    public class SpecNested<N> extends PersistentVolumeSpecFluent<SpecNested<N>> implements Nested<N>{

        private final PersistentVolumeSpecBuilder builder;
    
             SpecNested (){
        this.builder = new PersistentVolumeSpecBuilder(this);
        }
             SpecNested ( PersistentVolumeSpec item){
        this.builder = new PersistentVolumeSpecBuilder(this, item);
        }
    
            public N endSpec(){
            return and();
        }
            public N and(){
            return (N) PersistentVolumeFluent.this.withSpec(builder.build());
        }
    
}
    public class StatusNested<N> extends PersistentVolumeStatusFluent<StatusNested<N>> implements Nested<N>{

        private final PersistentVolumeStatusBuilder builder;
    
             StatusNested (){
        this.builder = new PersistentVolumeStatusBuilder(this);
        }
             StatusNested ( PersistentVolumeStatus item){
        this.builder = new PersistentVolumeStatusBuilder(this, item);
        }
    
            public N and(){
            return (N) PersistentVolumeFluent.this.withStatus(builder.build());
        }
            public N endStatus(){
            return and();
        }
    
}


}
