/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.BuildTriggerPolicy;
import io.fabric8.openshift.api.model.BuildTriggerPolicyFluent;
import io.fabric8.openshift.api.model.EditableBuildTriggerPolicy;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class BuildTriggerPolicyBuilder
extends BuildTriggerPolicyFluent<BuildTriggerPolicyBuilder>
implements VisitableBuilder<BuildTriggerPolicy, BuildTriggerPolicyBuilder> {
    BuildTriggerPolicyFluent<?> fluent;

    public BuildTriggerPolicyBuilder() {
        this(new BuildTriggerPolicy());
    }

    public BuildTriggerPolicyBuilder(BuildTriggerPolicyFluent<?> fluent) {
        this(fluent, new BuildTriggerPolicy());
    }

    public BuildTriggerPolicyBuilder(BuildTriggerPolicyFluent<?> fluent, BuildTriggerPolicy instance) {
        this.fluent = fluent;
        fluent.withGeneric(instance.getGeneric());
        fluent.withGithub(instance.getGithub());
        fluent.withImageChange(instance.getImageChange());
        fluent.withType(instance.getType());
    }

    public BuildTriggerPolicyBuilder(BuildTriggerPolicy instance) {
        this.fluent = this;
        this.withGeneric(instance.getGeneric());
        this.withGithub(instance.getGithub());
        this.withImageChange(instance.getImageChange());
        this.withType(instance.getType());
    }

    @Override
    public EditableBuildTriggerPolicy build() {
        EditableBuildTriggerPolicy buildable = new EditableBuildTriggerPolicy(this.fluent.getGeneric(), this.fluent.getGithub(), this.fluent.getImageChange(), this.fluent.getType());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

