package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;

public class BuildFluent<T extends BuildFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     Build.ApiVersion apiVersion;     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     VisitableBuilder<BuildSpec, ?> spec;     VisitableBuilder<BuildStatus, ?> status;     Map<String, Object> additionalProperties = new HashMap();

    public Build.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( Build.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNested<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ObjectMeta item){
    return new MetadataNested<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public BuildSpec getSpec(){
    return this.spec!=null?this.spec.build():null;
    }
    public T withSpec( BuildSpec spec){
    if (spec!=null){ this.spec= new BuildSpecBuilder(spec); _visitables.add(this.spec);} return (T) this;
    }
    public SpecNested<T> withNewSpec(){
    return new SpecNested<T>();
    }
    public SpecNested<T> withNewSpecLike( BuildSpec item){
    return new SpecNested<T>(item);
    }
    public SpecNested<T> editSpec(){
    return withNewSpecLike(getSpec());
    }
    public BuildStatus getStatus(){
    return this.status!=null?this.status.build():null;
    }
    public T withStatus( BuildStatus status){
    if (status!=null){ this.status= new BuildStatusBuilder(status); _visitables.add(this.status);} return (T) this;
    }
    public StatusNested<T> withNewStatus(){
    return new StatusNested<T>();
    }
    public StatusNested<T> withNewStatusLike( BuildStatus item){
    return new StatusNested<T>(item);
    }
    public StatusNested<T> editStatus(){
    return withNewStatusLike(getStatus());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }

    public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNested (){
        this.builder = new ObjectMetaBuilder(this);
        }
             MetadataNested ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
    
            public N endMetadata(){
            return and();
        }
            public N and(){
            return (N) BuildFluent.this.withMetadata(builder.build());
        }
    
}
    public class SpecNested<N> extends BuildSpecFluent<SpecNested<N>> implements Nested<N>{

        private final BuildSpecBuilder builder;
    
             SpecNested ( BuildSpec item){
        this.builder = new BuildSpecBuilder(this, item);
        }
             SpecNested (){
        this.builder = new BuildSpecBuilder(this);
        }
    
            public N endSpec(){
            return and();
        }
            public N and(){
            return (N) BuildFluent.this.withSpec(builder.build());
        }
    
}
    public class StatusNested<N> extends BuildStatusFluent<StatusNested<N>> implements Nested<N>{

        private final BuildStatusBuilder builder;
    
             StatusNested (){
        this.builder = new BuildStatusBuilder(this);
        }
             StatusNested ( BuildStatus item){
        this.builder = new BuildStatusBuilder(this, item);
        }
    
            public N endStatus(){
            return and();
        }
            public N and(){
            return (N) BuildFluent.this.withStatus(builder.build());
        }
    
}


}
