package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class ContainerPortBuilder extends ContainerPortFluent<ContainerPortBuilder> implements VisitableBuilder<ContainerPort,ContainerPortBuilder>{

     ContainerPortFluent<?> fluent;
public ContainerPortBuilder(){
    this(new ContainerPort());
}
public ContainerPortBuilder( ContainerPortFluent<?> fluent ){
    this(fluent, new ContainerPort());
}
public ContainerPortBuilder( ContainerPortFluent<?> fluent , ContainerPort instance ){
    this.fluent = fluent; fluent.withContainerPort(instance.getContainerPort()); fluent.withHostIP(instance.getHostIP()); fluent.withHostPort(instance.getHostPort()); fluent.withName(instance.getName()); fluent.withProtocol(instance.getProtocol()); 
}
public ContainerPortBuilder( ContainerPort instance ){
    this.fluent = this; this.withContainerPort(instance.getContainerPort()); this.withHostIP(instance.getHostIP()); this.withHostPort(instance.getHostPort()); this.withName(instance.getName()); this.withProtocol(instance.getProtocol()); 
}

public EditableContainerPort build(){
    EditableContainerPort buildable = new EditableContainerPort(fluent.getContainerPort(),fluent.getHostIP(),fluent.getHostPort(),fluent.getName(),fluent.getProtocol());
validate(buildable);
return buildable;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    