/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Config;
import io.fabric8.kubernetes.api.model.ConfigFluent;
import io.fabric8.kubernetes.api.model.EditableConfig;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ConfigBuilder
extends ConfigFluent<ConfigBuilder>
implements VisitableBuilder<Config, ConfigBuilder> {
    ConfigFluent<?> fluent;

    public ConfigBuilder() {
        this(new Config());
    }

    public ConfigBuilder(ConfigFluent<?> fluent) {
        this(fluent, new Config());
    }

    public ConfigBuilder(ConfigFluent<?> fluent, Config instance) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withClusters(instance.getClusters());
        fluent.withContexts(instance.getContexts());
        fluent.withCurrentContext(instance.getCurrentContext());
        fluent.withExtensions(instance.getExtensions());
        fluent.withKind(instance.getKind());
        fluent.withPreferences(instance.getPreferences());
        fluent.withUsers(instance.getUsers());
    }

    public ConfigBuilder(Config instance) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withClusters(instance.getClusters());
        this.withContexts(instance.getContexts());
        this.withCurrentContext(instance.getCurrentContext());
        this.withExtensions(instance.getExtensions());
        this.withKind(instance.getKind());
        this.withPreferences(instance.getPreferences());
        this.withUsers(instance.getUsers());
    }

    @Override
    public EditableConfig build() {
        EditableConfig buildable = new EditableConfig(this.fluent.getApiVersion(), this.fluent.getClusters(), this.fluent.getContexts(), this.fluent.getCurrentContext(), this.fluent.getExtensions(), this.fluent.getKind(), this.fluent.getPreferences(), this.fluent.getUsers());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigBuilder that = (ConfigBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

