package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public class ServicePortFluent<T extends ServicePortFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     String name;     Integer nodePort;     Integer port;     String protocol;     VisitableBuilder<IntOrString, ?> targetPort;     Map<String, Object> additionalProperties = new HashMap();

    public String getName(){
    return this.name;
    }
    public T withName( String name){
    this.name=name; return (T) this;
    }
    public Integer getNodePort(){
    return this.nodePort;
    }
    public T withNodePort( Integer nodePort){
    this.nodePort=nodePort; return (T) this;
    }
    public Integer getPort(){
    return this.port;
    }
    public T withPort( Integer port){
    this.port=port; return (T) this;
    }
    public String getProtocol(){
    return this.protocol;
    }
    public T withProtocol( String protocol){
    this.protocol=protocol; return (T) this;
    }
    public IntOrString getTargetPort(){
    return this.targetPort!=null?this.targetPort.build():null;
    }
    public T withTargetPort( IntOrString targetPort){
    if (targetPort!=null){ this.targetPort= new IntOrStringBuilder(targetPort); _visitables.add(this.targetPort);} return (T) this;
    }
    public TargetPortNested<T> withNewTargetPort(){
    return new TargetPortNested<T>();
    }
    public TargetPortNested<T> withNewTargetPortLike( IntOrString item){
    return new TargetPortNested<T>(item);
    }
    public TargetPortNested<T> editTargetPort(){
    return withNewTargetPortLike(getTargetPort());
    }
    public T withNewTargetPort( Integer intVal){
    return withTargetPort(new IntOrString(intVal));
    }
    public T withNewTargetPort( String strVal){
    return withTargetPort(new IntOrString(strVal));
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ServicePortFluent that = (ServicePortFluent) o;
if (name != null ? !name.equals(that.name) :that.name != null) return false;
if (nodePort != null ? !nodePort.equals(that.nodePort) :that.nodePort != null) return false;
if (port != null ? !port.equals(that.port) :that.port != null) return false;
if (protocol != null ? !protocol.equals(that.protocol) :that.protocol != null) return false;
if (targetPort != null ? !targetPort.equals(that.targetPort) :that.targetPort != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class TargetPortNested<N> extends IntOrStringFluent<TargetPortNested<N>> implements Nested<N>{

        private final IntOrStringBuilder builder;
    
             TargetPortNested (){
        this.builder = new IntOrStringBuilder(this);
        }
             TargetPortNested ( IntOrString item){
        this.builder = new IntOrStringBuilder(this, item);
        }
    
            public N endTargetPort(){
            return and();
        }
            public N and(){
            return (N) ServicePortFluent.this.withTargetPort(builder.build());
        }
    
}


}
