package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public class LoadBalancerStatusFluent<T extends LoadBalancerStatusFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     List<VisitableBuilder<LoadBalancerIngress, ?>> ingress = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();

    public T addToIngress( LoadBalancerIngress ...items){
    for (LoadBalancerIngress item : items) {LoadBalancerIngressBuilder builder = new LoadBalancerIngressBuilder(item);_visitables.add(builder);this.ingress.add(builder);} return (T)this;
    }
    public T removeFromIngress( LoadBalancerIngress ...items){
    for (LoadBalancerIngress item : items) {LoadBalancerIngressBuilder builder = new LoadBalancerIngressBuilder(item);_visitables.remove(builder);this.ingress.remove(builder);} return (T)this;
    }
    public List<LoadBalancerIngress> getIngress(){
    return build(ingress);
    }
    public T withIngress( List<LoadBalancerIngress> ingress){
    this.ingress.clear();if (ingress != null) {for (LoadBalancerIngress item : ingress){this.addToIngress(item);}} return (T) this;
    }
    public T withIngress( LoadBalancerIngress ...ingress){
    this.ingress.clear(); if (ingress != null) {for (LoadBalancerIngress item :ingress){ this.addToIngress(item);}} return (T) this;
    }
    public IngressNested<T> addNewIngres(){
    return new IngressNested<T>();
    }
    public IngressNested<T> addNewIngresLike( LoadBalancerIngress item){
    return new IngressNested<T>(item);
    }
    public T addNewIngres( String hostname,  String ip){
    return addToIngress(new LoadBalancerIngress(hostname, ip));
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
LoadBalancerStatusFluent that = (LoadBalancerStatusFluent) o;
if (ingress != null ? !ingress.equals(that.ingress) :that.ingress != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class IngressNested<N> extends LoadBalancerIngressFluent<IngressNested<N>> implements Nested<N>{

        private final LoadBalancerIngressBuilder builder;
    
             IngressNested (){
        this.builder = new LoadBalancerIngressBuilder(this);
        }
             IngressNested ( LoadBalancerIngress item){
        this.builder = new LoadBalancerIngressBuilder(this, item);
        }
    
            public N and(){
            return (N) LoadBalancerStatusFluent.this.addToIngress(builder.build());
        }
            public N endIngres(){
            return and();
        }
    
}


}
