package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.Map;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class ClusterRoleBindingBuilder extends ClusterRoleBindingFluent<ClusterRoleBindingBuilder> implements VisitableBuilder<ClusterRoleBinding,ClusterRoleBindingBuilder>{

     ClusterRoleBindingFluent<?> fluent;
public ClusterRoleBindingBuilder(){
    this(new ClusterRoleBinding());
}
public ClusterRoleBindingBuilder( ClusterRoleBindingFluent<?> fluent ){
    this(fluent, new ClusterRoleBinding());
}
public ClusterRoleBindingBuilder( ClusterRoleBindingFluent<?> fluent , ClusterRoleBinding instance ){
    this.fluent = fluent; fluent.withApiVersion(instance.getApiVersion()); fluent.withGroupNames(instance.getGroupNames()); fluent.withKind(instance.getKind()); fluent.withMetadata(instance.getMetadata()); fluent.withRoleRef(instance.getRoleRef()); fluent.withSubjects(instance.getSubjects()); fluent.withUserNames(instance.getUserNames()); 
}
public ClusterRoleBindingBuilder( ClusterRoleBinding instance ){
    this.fluent = this; this.withApiVersion(instance.getApiVersion()); this.withGroupNames(instance.getGroupNames()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); this.withRoleRef(instance.getRoleRef()); this.withSubjects(instance.getSubjects()); this.withUserNames(instance.getUserNames()); 
}

public EditableClusterRoleBinding build(){
    EditableClusterRoleBinding buildable = new EditableClusterRoleBinding(fluent.getApiVersion(),fluent.getGroupNames(),fluent.getKind(),fluent.getMetadata(),fluent.getRoleRef(),fluent.getSubjects(),fluent.getUserNames());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
ClusterRoleBindingBuilder that = (ClusterRoleBindingBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    