/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.openshift.api.model.ClusterPolicyBinding;
import io.fabric8.openshift.api.model.NamedClusterRoleBinding;
import io.fabric8.openshift.api.model.NamedClusterRoleBindingBuilder;
import io.fabric8.openshift.api.model.NamedClusterRoleBindingFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClusterPolicyBindingFluent<T extends ClusterPolicyBindingFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    ClusterPolicyBinding.ApiVersion apiVersion;
    String kind;
    String lastModified;
    VisitableBuilder<ObjectMeta, ?> metadata;
    VisitableBuilder<ObjectReference, ?> policyRef;
    List<VisitableBuilder<NamedClusterRoleBinding, ?>> roleBindings = new ArrayList();
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public ClusterPolicyBinding.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public T withApiVersion(ClusterPolicyBinding.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    public String getKind() {
        return this.kind;
    }

    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public T withLastModified(String lastModified) {
        this.lastModified = lastModified;
        return (T)this;
    }

    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    public MetadataNested<T> withNewMetadata() {
        return new MetadataNested();
    }

    public MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    public ObjectReference getPolicyRef() {
        return this.policyRef != null ? (ObjectReference)this.policyRef.build() : null;
    }

    public T withPolicyRef(ObjectReference policyRef) {
        if (policyRef != null) {
            this.policyRef = new ObjectReferenceBuilder(policyRef);
            this._visitables.add(this.policyRef);
        }
        return (T)this;
    }

    public PolicyRefNested<T> withNewPolicyRef() {
        return new PolicyRefNested();
    }

    public PolicyRefNested<T> withNewPolicyRefLike(ObjectReference item) {
        return new PolicyRefNested(item);
    }

    public PolicyRefNested<T> editPolicyRef() {
        return this.withNewPolicyRefLike(this.getPolicyRef());
    }

    public T addToRoleBindings(NamedClusterRoleBinding ... items) {
        for (NamedClusterRoleBinding item : items) {
            NamedClusterRoleBindingBuilder builder = new NamedClusterRoleBindingBuilder(item);
            this._visitables.add(builder);
            this.roleBindings.add(builder);
        }
        return (T)this;
    }

    public T removeFromRoleBindings(NamedClusterRoleBinding ... items) {
        for (NamedClusterRoleBinding item : items) {
            NamedClusterRoleBindingBuilder builder = new NamedClusterRoleBindingBuilder(item);
            this._visitables.remove(builder);
            this.roleBindings.remove(builder);
        }
        return (T)this;
    }

    public List<NamedClusterRoleBinding> getRoleBindings() {
        return this.build(this.roleBindings);
    }

    public T withRoleBindings(List<NamedClusterRoleBinding> roleBindings) {
        this.roleBindings.clear();
        if (roleBindings != null) {
            for (NamedClusterRoleBinding item : roleBindings) {
                this.addToRoleBindings(item);
            }
        }
        return (T)this;
    }

    public T withRoleBindings(NamedClusterRoleBinding ... roleBindings) {
        this.roleBindings.clear();
        if (roleBindings != null) {
            for (NamedClusterRoleBinding item : roleBindings) {
                this.addToRoleBindings(item);
            }
        }
        return (T)this;
    }

    public RoleBindingsNested<T> addNewRoleBinding() {
        return new RoleBindingsNested();
    }

    public RoleBindingsNested<T> addNewRoleBindingLike(NamedClusterRoleBinding item) {
        return new RoleBindingsNested(item);
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterPolicyBindingFluent that = (ClusterPolicyBindingFluent)o;
        if (this.apiVersion != null ? !this.apiVersion.equals((Object)that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.lastModified != null ? !this.lastModified.equals(that.lastModified) : that.lastModified != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.policyRef != null ? !this.policyRef.equals(that.policyRef) : that.policyRef != null) {
            return false;
        }
        if (this.roleBindings != null ? !this.roleBindings.equals(that.roleBindings) : that.roleBindings != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class RoleBindingsNested<N>
    extends NamedClusterRoleBindingFluent<RoleBindingsNested<N>>
    implements Nested<N> {
        private final NamedClusterRoleBindingBuilder builder;

        RoleBindingsNested(NamedClusterRoleBinding item) {
            this.builder = new NamedClusterRoleBindingBuilder(this, item);
        }

        RoleBindingsNested() {
            this.builder = new NamedClusterRoleBindingBuilder(this);
        }

        public N endRoleBinding() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ClusterPolicyBindingFluent.this.addToRoleBindings(this.builder.build());
        }
    }

    public class PolicyRefNested<N>
    extends ObjectReferenceFluent<PolicyRefNested<N>>
    implements Nested<N> {
        private final ObjectReferenceBuilder builder;

        PolicyRefNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        PolicyRefNested() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        public N endPolicyRef() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ClusterPolicyBindingFluent.this.withPolicyRef(this.builder.build());
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNested() {
            this.builder = new ObjectMetaBuilder(this);
        }

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterPolicyBindingFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

