package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class CustomDeploymentStrategyParamsBuilder extends CustomDeploymentStrategyParamsFluent<CustomDeploymentStrategyParamsBuilder> implements VisitableBuilder<CustomDeploymentStrategyParams,CustomDeploymentStrategyParamsBuilder>{

     CustomDeploymentStrategyParamsFluent<?> fluent;
public CustomDeploymentStrategyParamsBuilder(){
    this(new CustomDeploymentStrategyParams());
}
public CustomDeploymentStrategyParamsBuilder( CustomDeploymentStrategyParamsFluent<?> fluent ){
    this(fluent, new CustomDeploymentStrategyParams());
}
public CustomDeploymentStrategyParamsBuilder( CustomDeploymentStrategyParamsFluent<?> fluent , CustomDeploymentStrategyParams instance ){
    this.fluent = fluent; fluent.withCommand(instance.getCommand()); fluent.withEnvironment(instance.getEnvironment()); fluent.withImage(instance.getImage()); 
}
public CustomDeploymentStrategyParamsBuilder( CustomDeploymentStrategyParams instance ){
    this.fluent = this; this.withCommand(instance.getCommand()); this.withEnvironment(instance.getEnvironment()); this.withImage(instance.getImage()); 
}

public EditableCustomDeploymentStrategyParams build(){
    EditableCustomDeploymentStrategyParams buildable = new EditableCustomDeploymentStrategyParams(fluent.getCommand(),fluent.getEnvironment(),fluent.getImage());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
CustomDeploymentStrategyParamsBuilder that = (CustomDeploymentStrategyParamsBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    