package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class LoadBalancerStatusBuilder extends LoadBalancerStatusFluent<LoadBalancerStatusBuilder> implements VisitableBuilder<LoadBalancerStatus,LoadBalancerStatusBuilder>{

     LoadBalancerStatusFluent<?> fluent;
public LoadBalancerStatusBuilder(){
    this(new LoadBalancerStatus());
}
public LoadBalancerStatusBuilder( LoadBalancerStatusFluent<?> fluent ){
    this(fluent, new LoadBalancerStatus());
}
public LoadBalancerStatusBuilder( LoadBalancerStatusFluent<?> fluent , LoadBalancerStatus instance ){
    this.fluent = fluent; fluent.withIngress(instance.getIngress()); 
}
public LoadBalancerStatusBuilder( LoadBalancerStatus instance ){
    this.fluent = this; this.withIngress(instance.getIngress()); 
}

public EditableLoadBalancerStatus build(){
    EditableLoadBalancerStatus buildable = new EditableLoadBalancerStatus(fluent.getIngress());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
LoadBalancerStatusBuilder that = (LoadBalancerStatusBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    