package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.util.List;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;

public class DeploymentConfigSpecFluent<T extends DeploymentConfigSpecFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     Integer replicas;     Map<String, String> selector = new HashMap();     VisitableBuilder<DeploymentStrategy, ?> strategy;     VisitableBuilder<PodTemplateSpec, ?> template;     List<VisitableBuilder<DeploymentTriggerPolicy, ?>> triggers = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();

    public Integer getReplicas(){
    return this.replicas;
    }
    public T withReplicas( Integer replicas){
    this.replicas=replicas; return (T) this;
    }
    public T addToSelector( String key,  String value){
    if(key != null && value != null) {this.selector.put(key, value);} return (T)this;
    }
    public T removeFromSelector( String key){
    if(key != null) {this.selector.remove(key);} return (T)this;
    }
    public Map<String, String> getSelector(){
    return this.selector;
    }
    public T withSelector( Map<String, String> selector){
    this.selector.clear();if (selector != null) {this.selector.putAll(selector);} return (T) this;
    }
    public DeploymentStrategy getStrategy(){
    return this.strategy!=null?this.strategy.build():null;
    }
    public T withStrategy( DeploymentStrategy strategy){
    if (strategy!=null){ this.strategy= new DeploymentStrategyBuilder(strategy); _visitables.add(this.strategy);} return (T) this;
    }
    public StrategyNested<T> withNewStrategy(){
    return new StrategyNested<T>();
    }
    public StrategyNested<T> withNewStrategyLike( DeploymentStrategy item){
    return new StrategyNested<T>(item);
    }
    public StrategyNested<T> editStrategy(){
    return withNewStrategyLike(getStrategy());
    }
    public PodTemplateSpec getTemplate(){
    return this.template!=null?this.template.build():null;
    }
    public T withTemplate( PodTemplateSpec template){
    if (template!=null){ this.template= new PodTemplateSpecBuilder(template); _visitables.add(this.template);} return (T) this;
    }
    public TemplateNested<T> withNewTemplate(){
    return new TemplateNested<T>();
    }
    public TemplateNested<T> withNewTemplateLike( PodTemplateSpec item){
    return new TemplateNested<T>(item);
    }
    public TemplateNested<T> editTemplate(){
    return withNewTemplateLike(getTemplate());
    }
    public T addToTriggers( DeploymentTriggerPolicy ...items){
    for (DeploymentTriggerPolicy item : items) {DeploymentTriggerPolicyBuilder builder = new DeploymentTriggerPolicyBuilder(item);_visitables.add(builder);this.triggers.add(builder);} return (T)this;
    }
    public T removeFromTriggers( DeploymentTriggerPolicy ...items){
    for (DeploymentTriggerPolicy item : items) {DeploymentTriggerPolicyBuilder builder = new DeploymentTriggerPolicyBuilder(item);_visitables.remove(builder);this.triggers.remove(builder);} return (T)this;
    }
    public List<DeploymentTriggerPolicy> getTriggers(){
    return build(triggers);
    }
    public T withTriggers( List<DeploymentTriggerPolicy> triggers){
    this.triggers.clear();if (triggers != null) {for (DeploymentTriggerPolicy item : triggers){this.addToTriggers(item);}} return (T) this;
    }
    public T withTriggers( DeploymentTriggerPolicy ...triggers){
    this.triggers.clear(); if (triggers != null) {for (DeploymentTriggerPolicy item :triggers){ this.addToTriggers(item);}} return (T) this;
    }
    public TriggersNested<T> addNewTrigger(){
    return new TriggersNested<T>();
    }
    public TriggersNested<T> addNewTriggerLike( DeploymentTriggerPolicy item){
    return new TriggersNested<T>(item);
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
DeploymentConfigSpecFluent that = (DeploymentConfigSpecFluent) o;
if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
if (strategy != null ? !strategy.equals(that.strategy) :that.strategy != null) return false;
if (template != null ? !template.equals(that.template) :that.template != null) return false;
if (triggers != null ? !triggers.equals(that.triggers) :that.triggers != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class StrategyNested<N> extends DeploymentStrategyFluent<StrategyNested<N>> implements Nested<N>{

        private final DeploymentStrategyBuilder builder;
    
             StrategyNested (){
        this.builder = new DeploymentStrategyBuilder(this);
        }
             StrategyNested ( DeploymentStrategy item){
        this.builder = new DeploymentStrategyBuilder(this, item);
        }
    
            public N endStrategy(){
            return and();
        }
            public N and(){
            return (N) DeploymentConfigSpecFluent.this.withStrategy(builder.build());
        }
    
}
    public class TemplateNested<N> extends PodTemplateSpecFluent<TemplateNested<N>> implements Nested<N>{

        private final PodTemplateSpecBuilder builder;
    
             TemplateNested (){
        this.builder = new PodTemplateSpecBuilder(this);
        }
             TemplateNested ( PodTemplateSpec item){
        this.builder = new PodTemplateSpecBuilder(this, item);
        }
    
            public N endTemplate(){
            return and();
        }
            public N and(){
            return (N) DeploymentConfigSpecFluent.this.withTemplate(builder.build());
        }
    
}
    public class TriggersNested<N> extends DeploymentTriggerPolicyFluent<TriggersNested<N>> implements Nested<N>{

        private final DeploymentTriggerPolicyBuilder builder;
    
             TriggersNested (){
        this.builder = new DeploymentTriggerPolicyBuilder(this);
        }
             TriggersNested ( DeploymentTriggerPolicy item){
        this.builder = new DeploymentTriggerPolicyBuilder(this, item);
        }
    
            public N endTrigger(){
            return and();
        }
            public N and(){
            return (N) DeploymentConfigSpecFluent.this.addToTriggers(builder.build());
        }
    
}


}
