package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public class ImageStreamSpecFluent<T extends ImageStreamSpecFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     String dockerImageRepository;     List<VisitableBuilder<NamedTagReference, ?>> tags = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();

    public String getDockerImageRepository(){
    return this.dockerImageRepository;
    }
    public T withDockerImageRepository( String dockerImageRepository){
    this.dockerImageRepository=dockerImageRepository; return (T) this;
    }
    public T addToTags( NamedTagReference ...items){
    for (NamedTagReference item : items) {NamedTagReferenceBuilder builder = new NamedTagReferenceBuilder(item);_visitables.add(builder);this.tags.add(builder);} return (T)this;
    }
    public T removeFromTags( NamedTagReference ...items){
    for (NamedTagReference item : items) {NamedTagReferenceBuilder builder = new NamedTagReferenceBuilder(item);_visitables.remove(builder);this.tags.remove(builder);} return (T)this;
    }
    public List<NamedTagReference> getTags(){
    return build(tags);
    }
    public T withTags( List<NamedTagReference> tags){
    this.tags.clear();if (tags != null) {for (NamedTagReference item : tags){this.addToTags(item);}} return (T) this;
    }
    public T withTags( NamedTagReference ...tags){
    this.tags.clear(); if (tags != null) {for (NamedTagReference item :tags){ this.addToTags(item);}} return (T) this;
    }
    public TagsNested<T> addNewTag(){
    return new TagsNested<T>();
    }
    public TagsNested<T> addNewTagLike( NamedTagReference item){
    return new TagsNested<T>(item);
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ImageStreamSpecFluent that = (ImageStreamSpecFluent) o;
if (dockerImageRepository != null ? !dockerImageRepository.equals(that.dockerImageRepository) :that.dockerImageRepository != null) return false;
if (tags != null ? !tags.equals(that.tags) :that.tags != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class TagsNested<N> extends NamedTagReferenceFluent<TagsNested<N>> implements Nested<N>{

        private final NamedTagReferenceBuilder builder;
    
             TagsNested ( NamedTagReference item){
        this.builder = new NamedTagReferenceBuilder(this, item);
        }
             TagsNested (){
        this.builder = new NamedTagReferenceBuilder(this);
        }
    
            public N endTag(){
            return and();
        }
            public N and(){
            return (N) ImageStreamSpecFluent.this.addToTags(builder.build());
        }
    
}


}
