package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class EmptyDirVolumeSourceBuilder extends EmptyDirVolumeSourceFluent<EmptyDirVolumeSourceBuilder> implements VisitableBuilder<EmptyDirVolumeSource,EmptyDirVolumeSourceBuilder>{

     EmptyDirVolumeSourceFluent<?> fluent;
public EmptyDirVolumeSourceBuilder(){
    this(new EmptyDirVolumeSource());
}
public EmptyDirVolumeSourceBuilder( EmptyDirVolumeSourceFluent<?> fluent ){
    this(fluent, new EmptyDirVolumeSource());
}
public EmptyDirVolumeSourceBuilder( EmptyDirVolumeSourceFluent<?> fluent , EmptyDirVolumeSource instance ){
    this.fluent = fluent; fluent.withMedium(instance.getMedium()); 
}
public EmptyDirVolumeSourceBuilder( EmptyDirVolumeSource instance ){
    this.fluent = this; this.withMedium(instance.getMedium()); 
}

public EditableEmptyDirVolumeSource build(){
    EditableEmptyDirVolumeSource buildable = new EditableEmptyDirVolumeSource(fluent.getMedium());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
EmptyDirVolumeSourceBuilder that = (EmptyDirVolumeSourceBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    