/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.openshift.api.model.GitBuildSource;
import io.fabric8.openshift.api.model.GitBuildSourceBuilder;
import io.fabric8.openshift.api.model.GitBuildSourceFluent;
import java.util.HashMap;
import java.util.Map;

public class BuildSourceFluent<T extends BuildSourceFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    String contextDir;
    VisitableBuilder<GitBuildSource, ?> git;
    VisitableBuilder<LocalObjectReference, ?> sourceSecret;
    String type;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public String getContextDir() {
        return this.contextDir;
    }

    public T withContextDir(String contextDir) {
        this.contextDir = contextDir;
        return (T)this;
    }

    public GitBuildSource getGit() {
        return this.git != null ? (GitBuildSource)this.git.build() : null;
    }

    public T withGit(GitBuildSource git) {
        if (git != null) {
            this.git = new GitBuildSourceBuilder(git);
            this._visitables.add(this.git);
        }
        return (T)this;
    }

    public GitNested<T> withNewGit() {
        return new GitNested();
    }

    public GitNested<T> withNewGitLike(GitBuildSource item) {
        return new GitNested(item);
    }

    public GitNested<T> editGit() {
        return this.withNewGitLike(this.getGit());
    }

    public T withNewGit(String httpProxy, String httpsProxy, String ref, String uri) {
        return this.withGit(new GitBuildSource(httpProxy, httpsProxy, ref, uri));
    }

    public LocalObjectReference getSourceSecret() {
        return this.sourceSecret != null ? (LocalObjectReference)this.sourceSecret.build() : null;
    }

    public T withSourceSecret(LocalObjectReference sourceSecret) {
        if (sourceSecret != null) {
            this.sourceSecret = new LocalObjectReferenceBuilder(sourceSecret);
            this._visitables.add(this.sourceSecret);
        }
        return (T)this;
    }

    public SourceSecretNested<T> withNewSourceSecret() {
        return new SourceSecretNested();
    }

    public SourceSecretNested<T> withNewSourceSecretLike(LocalObjectReference item) {
        return new SourceSecretNested(item);
    }

    public SourceSecretNested<T> editSourceSecret() {
        return this.withNewSourceSecretLike(this.getSourceSecret());
    }

    public T withNewSourceSecret(String name) {
        return this.withSourceSecret(new LocalObjectReference(name));
    }

    public String getType() {
        return this.type;
    }

    public T withType(String type) {
        this.type = type;
        return (T)this;
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildSourceFluent that = (BuildSourceFluent)o;
        if (this.contextDir != null ? !this.contextDir.equals(that.contextDir) : that.contextDir != null) {
            return false;
        }
        if (this.git != null ? !this.git.equals(that.git) : that.git != null) {
            return false;
        }
        if (this.sourceSecret != null ? !this.sourceSecret.equals(that.sourceSecret) : that.sourceSecret != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class SourceSecretNested<N>
    extends LocalObjectReferenceFluent<SourceSecretNested<N>>
    implements Nested<N> {
        private final LocalObjectReferenceBuilder builder;

        SourceSecretNested() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        SourceSecretNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildSourceFluent.this.withSourceSecret(this.builder.build());
        }

        public N endSourceSecret() {
            return this.and();
        }
    }

    public class GitNested<N>
    extends GitBuildSourceFluent<GitNested<N>>
    implements Nested<N> {
        private final GitBuildSourceBuilder builder;

        GitNested(GitBuildSource item) {
            this.builder = new GitBuildSourceBuilder(this, item);
        }

        GitNested() {
            this.builder = new GitBuildSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildSourceFluent.this.withGit(this.builder.build());
        }

        public N endGit() {
            return this.and();
        }
    }
}

