package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.Map;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class UserBuilder extends UserFluent<UserBuilder> implements VisitableBuilder<User,UserBuilder>{

     UserFluent<?> fluent;
public UserBuilder(){
    this(new User());
}
public UserBuilder( UserFluent<?> fluent ){
    this(fluent, new User());
}
public UserBuilder( UserFluent<?> fluent , User instance ){
    this.fluent = fluent; fluent.withApiVersion(instance.getApiVersion()); fluent.withFullName(instance.getFullName()); fluent.withGroups(instance.getGroups()); fluent.withIdentities(instance.getIdentities()); fluent.withKind(instance.getKind()); fluent.withMetadata(instance.getMetadata()); 
}
public UserBuilder( User instance ){
    this.fluent = this; this.withApiVersion(instance.getApiVersion()); this.withFullName(instance.getFullName()); this.withGroups(instance.getGroups()); this.withIdentities(instance.getIdentities()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); 
}

public EditableUser build(){
    EditableUser buildable = new EditableUser(fluent.getApiVersion(),fluent.getFullName(),fluent.getGroups(),fluent.getIdentities(),fluent.getKind(),fluent.getMetadata());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
UserBuilder that = (UserBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    