/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.openshift.api.model.Identity;
import java.util.HashMap;
import java.util.Map;

public class IdentityFluent<T extends IdentityFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    Identity.ApiVersion apiVersion;
    Map<String, String> extra = new HashMap<String, String>();
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    String providerName;
    String providerUserName;
    VisitableBuilder<ObjectReference, ?> user;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public Identity.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public T withApiVersion(Identity.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    public T addToExtra(String key, String value) {
        if (key != null && value != null) {
            this.extra.put(key, value);
        }
        return (T)this;
    }

    public T removeFromExtra(String key) {
        if (key != null) {
            this.extra.remove(key);
        }
        return (T)this;
    }

    public Map<String, String> getExtra() {
        return this.extra;
    }

    public T withExtra(Map<String, String> extra) {
        this.extra.clear();
        if (extra != null) {
            this.extra.putAll(extra);
        }
        return (T)this;
    }

    public String getKind() {
        return this.kind;
    }

    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    public MetadataNested<T> withNewMetadata() {
        return new MetadataNested();
    }

    public MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    public String getProviderName() {
        return this.providerName;
    }

    public T withProviderName(String providerName) {
        this.providerName = providerName;
        return (T)this;
    }

    public String getProviderUserName() {
        return this.providerUserName;
    }

    public T withProviderUserName(String providerUserName) {
        this.providerUserName = providerUserName;
        return (T)this;
    }

    public ObjectReference getUser() {
        return this.user != null ? (ObjectReference)this.user.build() : null;
    }

    public T withUser(ObjectReference user) {
        if (user != null) {
            this.user = new ObjectReferenceBuilder(user);
            this._visitables.add(this.user);
        }
        return (T)this;
    }

    public UserNested<T> withNewUser() {
        return new UserNested();
    }

    public UserNested<T> withNewUserLike(ObjectReference item) {
        return new UserNested(item);
    }

    public UserNested<T> editUser() {
        return this.withNewUserLike(this.getUser());
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityFluent that = (IdentityFluent)o;
        if (this.apiVersion != null ? !this.apiVersion.equals((Object)that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.extra != null ? !this.extra.equals(that.extra) : that.extra != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.providerName != null ? !this.providerName.equals(that.providerName) : that.providerName != null) {
            return false;
        }
        if (this.providerUserName != null ? !this.providerUserName.equals(that.providerUserName) : that.providerUserName != null) {
            return false;
        }
        if (this.user != null ? !this.user.equals(that.user) : that.user != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class UserNested<N>
    extends ObjectReferenceFluent<UserNested<N>>
    implements Nested<N> {
        private final ObjectReferenceBuilder builder;

        UserNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        UserNested() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        public N endUser() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)IdentityFluent.this.withUser(this.builder.build());
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNested() {
            this.builder = new ObjectMetaBuilder(this);
        }

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        public N endMetadata() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)IdentityFluent.this.withMetadata(this.builder.build());
        }
    }
}

