package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class GitSourceRevisionBuilder extends GitSourceRevisionFluent<GitSourceRevisionBuilder> implements VisitableBuilder<GitSourceRevision,GitSourceRevisionBuilder>{

     GitSourceRevisionFluent<?> fluent;
public GitSourceRevisionBuilder(){
    this(new GitSourceRevision());
}
public GitSourceRevisionBuilder( GitSourceRevisionFluent<?> fluent ){
    this(fluent, new GitSourceRevision());
}
public GitSourceRevisionBuilder( GitSourceRevisionFluent<?> fluent , GitSourceRevision instance ){
    this.fluent = fluent; fluent.withAuthor(instance.getAuthor()); fluent.withCommit(instance.getCommit()); fluent.withCommitter(instance.getCommitter()); fluent.withMessage(instance.getMessage()); 
}
public GitSourceRevisionBuilder( GitSourceRevision instance ){
    this.fluent = this; this.withAuthor(instance.getAuthor()); this.withCommit(instance.getCommit()); this.withCommitter(instance.getCommitter()); this.withMessage(instance.getMessage()); 
}

public EditableGitSourceRevision build(){
    EditableGitSourceRevision buildable = new EditableGitSourceRevision(fluent.getAuthor(),fluent.getCommit(),fluent.getCommitter(),fluent.getMessage());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
GitSourceRevisionBuilder that = (GitSourceRevisionBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    