package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class BuildSourceBuilder extends BuildSourceFluent<BuildSourceBuilder> implements VisitableBuilder<BuildSource,BuildSourceBuilder>{

     BuildSourceFluent<?> fluent;
public BuildSourceBuilder(){
    this(new BuildSource());
}
public BuildSourceBuilder( BuildSourceFluent<?> fluent ){
    this(fluent, new BuildSource());
}
public BuildSourceBuilder( BuildSourceFluent<?> fluent , BuildSource instance ){
    this.fluent = fluent; fluent.withContextDir(instance.getContextDir()); fluent.withGit(instance.getGit()); fluent.withSourceSecret(instance.getSourceSecret()); fluent.withType(instance.getType()); 
}
public BuildSourceBuilder( BuildSource instance ){
    this.fluent = this; this.withContextDir(instance.getContextDir()); this.withGit(instance.getGit()); this.withSourceSecret(instance.getSourceSecret()); this.withType(instance.getType()); 
}

public EditableBuildSource build(){
    EditableBuildSource buildable = new EditableBuildSource(fluent.getContextDir(),fluent.getGit(),fluent.getSourceSecret(),fluent.getType());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
BuildSourceBuilder that = (BuildSourceBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    