package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class PersistentVolumeClaimVolumeSourceBuilder extends PersistentVolumeClaimVolumeSourceFluent<PersistentVolumeClaimVolumeSourceBuilder> implements VisitableBuilder<PersistentVolumeClaimVolumeSource,PersistentVolumeClaimVolumeSourceBuilder>{

     PersistentVolumeClaimVolumeSourceFluent<?> fluent;
public PersistentVolumeClaimVolumeSourceBuilder(){
    this(new PersistentVolumeClaimVolumeSource());
}
public PersistentVolumeClaimVolumeSourceBuilder( PersistentVolumeClaimVolumeSourceFluent<?> fluent ){
    this(fluent, new PersistentVolumeClaimVolumeSource());
}
public PersistentVolumeClaimVolumeSourceBuilder( PersistentVolumeClaimVolumeSourceFluent<?> fluent , PersistentVolumeClaimVolumeSource instance ){
    this.fluent = fluent; fluent.withClaimName(instance.getClaimName()); fluent.withReadOnly(instance.getReadOnly()); 
}
public PersistentVolumeClaimVolumeSourceBuilder( PersistentVolumeClaimVolumeSource instance ){
    this.fluent = this; this.withClaimName(instance.getClaimName()); this.withReadOnly(instance.getReadOnly()); 
}

public EditablePersistentVolumeClaimVolumeSource build(){
    EditablePersistentVolumeClaimVolumeSource buildable = new EditablePersistentVolumeClaimVolumeSource(fluent.getClaimName(),fluent.isReadOnly());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
PersistentVolumeClaimVolumeSourceBuilder that = (PersistentVolumeClaimVolumeSourceBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    