
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "annotations",
    "creationTimestamp",
    "deletionTimestamp",
    "generateName",
    "generation",
    "labels",
    "name",
    "namespace",
    "resourceVersion",
    "selfLink",
    "uid"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = true, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = @Inline(type = Doneable.class, prefix = "Doneable", value = "done"))
public class ObjectMeta {

    /**
     * map of string keys and values that can be used by external tooling to store and retrieve arbitrary metadata about objects; see http://releases.k8s.io/HEAD/docs/user-guide/annotations.md
     * 
     */
    @JsonProperty("annotations")
    @Valid
    private Map<String, String> annotations;
    /**
     * RFC 3339 date and time at which the object was created; populated by the system
     * 
     */
    @JsonProperty("creationTimestamp")
    private java.lang.String creationTimestamp;
    /**
     * RFC 3339 date and time at which the object will be deleted; populated by the system when a graceful deletion is requested
     * 
     */
    @JsonProperty("deletionTimestamp")
    private java.lang.String deletionTimestamp;
    /**
     * an optional prefix to use to generate a unique name; has the same validation rules as name; optional
     * 
     */
    @JsonProperty("generateName")
    private java.lang.String generateName;
    /**
     * a sequence number representing a specific generation of the desired state; populated by the system; read-only
     * 
     */
    @JsonProperty("generation")
    private Long generation;
    /**
     * map of string keys and values that can be used to organize and categorize objects; may match selectors of replication controllers and services; see http://releases.k8s.io/HEAD/docs/user-guide/labels.md
     * 
     */
    @JsonProperty("labels")
    @Valid
    private Map<String, String> labels;
    /**
     * string that identifies an object. Must be unique within a namespace; cannot be updated; see http://releases.k8s.io/HEAD/docs/user-guide/identifiers.md#names
     * 
     */
    @JsonProperty("name")
    @Pattern(regexp = "^[a-z0-9]([-a-z0-9]*[a-z0-9])?$")
    @Size(max = 63)
    private java.lang.String name;
    /**
     * namespace of the object; must be a DNS_LABEL; cannot be updated; see http://releases.k8s.io/HEAD/docs/user-guide/namespaces.md
     * 
     */
    @JsonProperty("namespace")
    @Pattern(regexp = "^[a-z0-9]([-a-z0-9]*[a-z0-9])?(\\.[a-z0-9]([-a-z0-9]*[a-z0-9])?)*$")
    @Size(max = 253)
    private java.lang.String namespace;
    /**
     * string that identifies the internal version of this object that can be used by clients to determine when objects have changed; populated by the system
     * 
     */
    @JsonProperty("resourceVersion")
    private java.lang.String resourceVersion;
    /**
     * URL for the object; populated by the system
     * 
     */
    @JsonProperty("selfLink")
    private java.lang.String selfLink;
    /**
     * unique UUID across space and time; populated by the system; read-only; see http://releases.k8s.io/HEAD/docs/user-guide/identifiers.md#uids
     * 
     */
    @JsonProperty("uid")
    private java.lang.String uid;
    @JsonIgnore
    private Map<java.lang.String, Object> additionalProperties = new HashMap<java.lang.String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public ObjectMeta() {
    }

    /**
     * 
     * @param uid
     * @param deletionTimestamp
     * @param resourceVersion
     * @param name
     * @param labels
     * @param generateName
     * @param selfLink
     * @param creationTimestamp
     * @param annotations
     * @param generation
     * @param namespace
     */
    public ObjectMeta(Map<String, String> annotations, java.lang.String creationTimestamp, java.lang.String deletionTimestamp, java.lang.String generateName, Long generation, Map<String, String> labels, java.lang.String name, java.lang.String namespace, java.lang.String resourceVersion, java.lang.String selfLink, java.lang.String uid) {
        this.annotations = annotations;
        this.creationTimestamp = creationTimestamp;
        this.deletionTimestamp = deletionTimestamp;
        this.generateName = generateName;
        this.generation = generation;
        this.labels = labels;
        this.name = name;
        this.namespace = namespace;
        this.resourceVersion = resourceVersion;
        this.selfLink = selfLink;
        this.uid = uid;
    }

    /**
     * map of string keys and values that can be used by external tooling to store and retrieve arbitrary metadata about objects; see http://releases.k8s.io/HEAD/docs/user-guide/annotations.md
     * 
     * @return
     *     The annotations
     */
    @JsonProperty("annotations")
    public Map<String, String> getAnnotations() {
        return annotations;
    }

    /**
     * map of string keys and values that can be used by external tooling to store and retrieve arbitrary metadata about objects; see http://releases.k8s.io/HEAD/docs/user-guide/annotations.md
     * 
     * @param annotations
     *     The annotations
     */
    @JsonProperty("annotations")
    public void setAnnotations(Map<String, String> annotations) {
        this.annotations = annotations;
    }

    /**
     * RFC 3339 date and time at which the object was created; populated by the system
     * 
     * @return
     *     The creationTimestamp
     */
    @JsonProperty("creationTimestamp")
    public java.lang.String getCreationTimestamp() {
        return creationTimestamp;
    }

    /**
     * RFC 3339 date and time at which the object was created; populated by the system
     * 
     * @param creationTimestamp
     *     The creationTimestamp
     */
    @JsonProperty("creationTimestamp")
    public void setCreationTimestamp(java.lang.String creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    /**
     * RFC 3339 date and time at which the object will be deleted; populated by the system when a graceful deletion is requested
     * 
     * @return
     *     The deletionTimestamp
     */
    @JsonProperty("deletionTimestamp")
    public java.lang.String getDeletionTimestamp() {
        return deletionTimestamp;
    }

    /**
     * RFC 3339 date and time at which the object will be deleted; populated by the system when a graceful deletion is requested
     * 
     * @param deletionTimestamp
     *     The deletionTimestamp
     */
    @JsonProperty("deletionTimestamp")
    public void setDeletionTimestamp(java.lang.String deletionTimestamp) {
        this.deletionTimestamp = deletionTimestamp;
    }

    /**
     * an optional prefix to use to generate a unique name; has the same validation rules as name; optional
     * 
     * @return
     *     The generateName
     */
    @JsonProperty("generateName")
    public java.lang.String getGenerateName() {
        return generateName;
    }

    /**
     * an optional prefix to use to generate a unique name; has the same validation rules as name; optional
     * 
     * @param generateName
     *     The generateName
     */
    @JsonProperty("generateName")
    public void setGenerateName(java.lang.String generateName) {
        this.generateName = generateName;
    }

    /**
     * a sequence number representing a specific generation of the desired state; populated by the system; read-only
     * 
     * @return
     *     The generation
     */
    @JsonProperty("generation")
    public Long getGeneration() {
        return generation;
    }

    /**
     * a sequence number representing a specific generation of the desired state; populated by the system; read-only
     * 
     * @param generation
     *     The generation
     */
    @JsonProperty("generation")
    public void setGeneration(Long generation) {
        this.generation = generation;
    }

    /**
     * map of string keys and values that can be used to organize and categorize objects; may match selectors of replication controllers and services; see http://releases.k8s.io/HEAD/docs/user-guide/labels.md
     * 
     * @return
     *     The labels
     */
    @JsonProperty("labels")
    public Map<String, String> getLabels() {
        return labels;
    }

    /**
     * map of string keys and values that can be used to organize and categorize objects; may match selectors of replication controllers and services; see http://releases.k8s.io/HEAD/docs/user-guide/labels.md
     * 
     * @param labels
     *     The labels
     */
    @JsonProperty("labels")
    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    /**
     * string that identifies an object. Must be unique within a namespace; cannot be updated; see http://releases.k8s.io/HEAD/docs/user-guide/identifiers.md#names
     * 
     * @return
     *     The name
     */
    @JsonProperty("name")
    public java.lang.String getName() {
        return name;
    }

    /**
     * string that identifies an object. Must be unique within a namespace; cannot be updated; see http://releases.k8s.io/HEAD/docs/user-guide/identifiers.md#names
     * 
     * @param name
     *     The name
     */
    @JsonProperty("name")
    public void setName(java.lang.String name) {
        this.name = name;
    }

    /**
     * namespace of the object; must be a DNS_LABEL; cannot be updated; see http://releases.k8s.io/HEAD/docs/user-guide/namespaces.md
     * 
     * @return
     *     The namespace
     */
    @JsonProperty("namespace")
    public java.lang.String getNamespace() {
        return namespace;
    }

    /**
     * namespace of the object; must be a DNS_LABEL; cannot be updated; see http://releases.k8s.io/HEAD/docs/user-guide/namespaces.md
     * 
     * @param namespace
     *     The namespace
     */
    @JsonProperty("namespace")
    public void setNamespace(java.lang.String namespace) {
        this.namespace = namespace;
    }

    /**
     * string that identifies the internal version of this object that can be used by clients to determine when objects have changed; populated by the system
     * 
     * @return
     *     The resourceVersion
     */
    @JsonProperty("resourceVersion")
    public java.lang.String getResourceVersion() {
        return resourceVersion;
    }

    /**
     * string that identifies the internal version of this object that can be used by clients to determine when objects have changed; populated by the system
     * 
     * @param resourceVersion
     *     The resourceVersion
     */
    @JsonProperty("resourceVersion")
    public void setResourceVersion(java.lang.String resourceVersion) {
        this.resourceVersion = resourceVersion;
    }

    /**
     * URL for the object; populated by the system
     * 
     * @return
     *     The selfLink
     */
    @JsonProperty("selfLink")
    public java.lang.String getSelfLink() {
        return selfLink;
    }

    /**
     * URL for the object; populated by the system
     * 
     * @param selfLink
     *     The selfLink
     */
    @JsonProperty("selfLink")
    public void setSelfLink(java.lang.String selfLink) {
        this.selfLink = selfLink;
    }

    /**
     * unique UUID across space and time; populated by the system; read-only; see http://releases.k8s.io/HEAD/docs/user-guide/identifiers.md#uids
     * 
     * @return
     *     The uid
     */
    @JsonProperty("uid")
    public java.lang.String getUid() {
        return uid;
    }

    /**
     * unique UUID across space and time; populated by the system; read-only; see http://releases.k8s.io/HEAD/docs/user-guide/identifiers.md#uids
     * 
     * @param uid
     *     The uid
     */
    @JsonProperty("uid")
    public void setUid(java.lang.String uid) {
        this.uid = uid;
    }

    @JsonAnyGetter
    public Map<java.lang.String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(java.lang.String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
