package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class IntOrStringBuilder extends IntOrStringFluent<IntOrStringBuilder> implements VisitableBuilder<IntOrString,IntOrStringBuilder>{

     IntOrStringFluent<?> fluent;
public IntOrStringBuilder(){
    this(new IntOrString());
}
public IntOrStringBuilder( IntOrStringFluent<?> fluent ){
    this(fluent, new IntOrString());
}
public IntOrStringBuilder( IntOrStringFluent<?> fluent , IntOrString instance ){
    this.fluent = fluent; fluent.withIntVal(instance.getIntVal()); fluent.withKind(instance.getKind()); fluent.withStrVal(instance.getStrVal()); fluent.withAdditionalProperties(instance.getAdditionalProperties()); 
}
public IntOrStringBuilder( IntOrString instance ){
    this.fluent = this; this.withIntVal(instance.getIntVal()); this.withKind(instance.getKind()); this.withStrVal(instance.getStrVal()); this.withAdditionalProperties(instance.getAdditionalProperties()); 
}

public EditableIntOrString build(){
    EditableIntOrString buildable = new EditableIntOrString(fluent.getIntVal(),fluent.getKind(),fluent.getStrVal(),fluent.getAdditionalProperties());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
IntOrStringBuilder that = (IntOrStringBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    