package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class BuildTriggerPolicyBuilder extends BuildTriggerPolicyFluent<BuildTriggerPolicyBuilder> implements VisitableBuilder<BuildTriggerPolicy,BuildTriggerPolicyBuilder>{

     BuildTriggerPolicyFluent<?> fluent;
public BuildTriggerPolicyBuilder(){
    this(new BuildTriggerPolicy());
}
public BuildTriggerPolicyBuilder( BuildTriggerPolicyFluent<?> fluent ){
    this(fluent, new BuildTriggerPolicy());
}
public BuildTriggerPolicyBuilder( BuildTriggerPolicyFluent<?> fluent , BuildTriggerPolicy instance ){
    this.fluent = fluent; fluent.withGeneric(instance.getGeneric()); fluent.withGithub(instance.getGithub()); fluent.withImageChange(instance.getImageChange()); fluent.withType(instance.getType()); 
}
public BuildTriggerPolicyBuilder( BuildTriggerPolicy instance ){
    this.fluent = this; this.withGeneric(instance.getGeneric()); this.withGithub(instance.getGithub()); this.withImageChange(instance.getImageChange()); this.withType(instance.getType()); 
}

public EditableBuildTriggerPolicy build(){
    EditableBuildTriggerPolicy buildable = new EditableBuildTriggerPolicy(fluent.getGeneric(),fluent.getGithub(),fluent.getImageChange(),fluent.getType());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
BuildTriggerPolicyBuilder that = (BuildTriggerPolicyBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    