package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class PersistentVolumeStatusBuilder extends PersistentVolumeStatusFluent<PersistentVolumeStatusBuilder> implements VisitableBuilder<PersistentVolumeStatus,PersistentVolumeStatusBuilder>{

     PersistentVolumeStatusFluent<?> fluent;
public PersistentVolumeStatusBuilder(){
    this(new PersistentVolumeStatus());
}
public PersistentVolumeStatusBuilder( PersistentVolumeStatusFluent<?> fluent ){
    this(fluent, new PersistentVolumeStatus());
}
public PersistentVolumeStatusBuilder( PersistentVolumeStatusFluent<?> fluent , PersistentVolumeStatus instance ){
    this.fluent = fluent; fluent.withMessage(instance.getMessage()); fluent.withPhase(instance.getPhase()); fluent.withReason(instance.getReason()); 
}
public PersistentVolumeStatusBuilder( PersistentVolumeStatus instance ){
    this.fluent = this; this.withMessage(instance.getMessage()); this.withPhase(instance.getPhase()); this.withReason(instance.getReason()); 
}

public EditablePersistentVolumeStatus build(){
    EditablePersistentVolumeStatus buildable = new EditablePersistentVolumeStatus(fluent.getMessage(),fluent.getPhase(),fluent.getReason());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
PersistentVolumeStatusBuilder that = (PersistentVolumeStatusBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    