
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "fieldPath",
    "kind",
    "name",
    "namespace",
    "resourceVersion",
    "uid"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = true, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = @Inline(type = Doneable.class, prefix = "Doneable", value = "done"))
public class ObjectReference {

    /**
     * API version of the referent
     * 
     */
    @JsonProperty("apiVersion")
    private String apiVersion;
    /**
     * if referring to a piece of an object instead of an entire object
     * 
     */
    @JsonProperty("fieldPath")
    private String fieldPath;
    /**
     * kind of the referent; see http://releases.k8s.io/v1.0.0/docs/api-conventions.md#types-kinds
     * 
     */
    @JsonProperty("kind")
    private String kind;
    /**
     * name of the referent; see http://releases.k8s.io/v1.0.0/docs/identifiers.md#names
     * 
     */
    @JsonProperty("name")
    private String name;
    /**
     * namespace of the referent; see http://releases.k8s.io/v1.0.0/docs/namespaces.md
     * 
     */
    @JsonProperty("namespace")
    private String namespace;
    /**
     * specific resourceVersion to which this reference is made
     * 
     */
    @JsonProperty("resourceVersion")
    private String resourceVersion;
    /**
     * uid of the referent; see http://releases.k8s.io/v1.0.0/docs/identifiers.md#uids
     * 
     */
    @JsonProperty("uid")
    private String uid;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public ObjectReference() {
    }

    /**
     * 
     * @param uid
     * @param apiVersion
     * @param resourceVersion
     * @param name
     * @param fieldPath
     * @param kind
     * @param namespace
     */
    public ObjectReference(String apiVersion, String fieldPath, String kind, String name, String namespace, String resourceVersion, String uid) {
        this.apiVersion = apiVersion;
        this.fieldPath = fieldPath;
        this.kind = kind;
        this.name = name;
        this.namespace = namespace;
        this.resourceVersion = resourceVersion;
        this.uid = uid;
    }

    /**
     * API version of the referent
     * 
     * @return
     *     The apiVersion
     */
    @JsonProperty("apiVersion")
    public String getApiVersion() {
        return apiVersion;
    }

    /**
     * API version of the referent
     * 
     * @param apiVersion
     *     The apiVersion
     */
    @JsonProperty("apiVersion")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    /**
     * if referring to a piece of an object instead of an entire object
     * 
     * @return
     *     The fieldPath
     */
    @JsonProperty("fieldPath")
    public String getFieldPath() {
        return fieldPath;
    }

    /**
     * if referring to a piece of an object instead of an entire object
     * 
     * @param fieldPath
     *     The fieldPath
     */
    @JsonProperty("fieldPath")
    public void setFieldPath(String fieldPath) {
        this.fieldPath = fieldPath;
    }

    /**
     * kind of the referent; see http://releases.k8s.io/v1.0.0/docs/api-conventions.md#types-kinds
     * 
     * @return
     *     The kind
     */
    @JsonProperty("kind")
    public String getKind() {
        return kind;
    }

    /**
     * kind of the referent; see http://releases.k8s.io/v1.0.0/docs/api-conventions.md#types-kinds
     * 
     * @param kind
     *     The kind
     */
    @JsonProperty("kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    /**
     * name of the referent; see http://releases.k8s.io/v1.0.0/docs/identifiers.md#names
     * 
     * @return
     *     The name
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * name of the referent; see http://releases.k8s.io/v1.0.0/docs/identifiers.md#names
     * 
     * @param name
     *     The name
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    /**
     * namespace of the referent; see http://releases.k8s.io/v1.0.0/docs/namespaces.md
     * 
     * @return
     *     The namespace
     */
    @JsonProperty("namespace")
    public String getNamespace() {
        return namespace;
    }

    /**
     * namespace of the referent; see http://releases.k8s.io/v1.0.0/docs/namespaces.md
     * 
     * @param namespace
     *     The namespace
     */
    @JsonProperty("namespace")
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    /**
     * specific resourceVersion to which this reference is made
     * 
     * @return
     *     The resourceVersion
     */
    @JsonProperty("resourceVersion")
    public String getResourceVersion() {
        return resourceVersion;
    }

    /**
     * specific resourceVersion to which this reference is made
     * 
     * @param resourceVersion
     *     The resourceVersion
     */
    @JsonProperty("resourceVersion")
    public void setResourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
    }

    /**
     * uid of the referent; see http://releases.k8s.io/v1.0.0/docs/identifiers.md#uids
     * 
     * @return
     *     The uid
     */
    @JsonProperty("uid")
    public String getUid() {
        return uid;
    }

    /**
     * uid of the referent; see http://releases.k8s.io/v1.0.0/docs/identifiers.md#uids
     * 
     * @param uid
     *     The uid
     */
    @JsonProperty("uid")
    public void setUid(String uid) {
        this.uid = uid;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
