package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class TLSConfigFluent<T extends TLSConfigFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     String caCertificate;     String certificate;     String destinationCACertificate;     String key;     String termination;     Map<String, Object> additionalProperties = new HashMap();

    public String getCaCertificate(){
    return this.caCertificate;
    }
    public T withCaCertificate( String caCertificate){
    this.caCertificate=caCertificate; return (T) this;
    }
    public String getCertificate(){
    return this.certificate;
    }
    public T withCertificate( String certificate){
    this.certificate=certificate; return (T) this;
    }
    public String getDestinationCACertificate(){
    return this.destinationCACertificate;
    }
    public T withDestinationCACertificate( String destinationCACertificate){
    this.destinationCACertificate=destinationCACertificate; return (T) this;
    }
    public String getKey(){
    return this.key;
    }
    public T withKey( String key){
    this.key=key; return (T) this;
    }
    public String getTermination(){
    return this.termination;
    }
    public T withTermination( String termination){
    this.termination=termination; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
TLSConfigFluent that = (TLSConfigFluent) o;
if (caCertificate != null ? !caCertificate.equals(that.caCertificate) :that.caCertificate != null) return false;
if (certificate != null ? !certificate.equals(that.certificate) :that.certificate != null) return false;
if (destinationCACertificate != null ? !destinationCACertificate.equals(that.destinationCACertificate) :that.destinationCACertificate != null) return false;
if (key != null ? !key.equals(that.key) :that.key != null) return false;
if (termination != null ? !termination.equals(that.termination) :that.termination != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
