package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class ObjectFieldSelectorFluent<T extends ObjectFieldSelectorFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     String apiVersion;     String fieldPath;     Map<String, Object> additionalProperties = new HashMap();

    public String getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( String apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public String getFieldPath(){
    return this.fieldPath;
    }
    public T withFieldPath( String fieldPath){
    this.fieldPath=fieldPath; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ObjectFieldSelectorFluent that = (ObjectFieldSelectorFluent) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (fieldPath != null ? !fieldPath.equals(that.fieldPath) :that.fieldPath != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
