package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;

public class ClusterRoleFluent<T extends ClusterRoleFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     ClusterRole.ApiVersion apiVersion;     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     List<VisitableBuilder<PolicyRule, ?>> rules = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();

    public ClusterRole.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( ClusterRole.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNested<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ObjectMeta item){
    return new MetadataNested<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public T addToRules( PolicyRule ...items){
    for (PolicyRule item : items) {PolicyRuleBuilder builder = new PolicyRuleBuilder(item);_visitables.add(builder);this.rules.add(builder);} return (T)this;
    }
    public T removeFromRules( PolicyRule ...items){
    for (PolicyRule item : items) {PolicyRuleBuilder builder = new PolicyRuleBuilder(item);_visitables.remove(builder);this.rules.remove(builder);} return (T)this;
    }
    public List<PolicyRule> getRules(){
    return build(rules);
    }
    public T withRules( List<PolicyRule> rules){
    this.rules.clear();if (rules != null) {for (PolicyRule item : rules){this.addToRules(item);}} return (T) this;
    }
    public T withRules( PolicyRule ...rules){
    this.rules.clear(); if (rules != null) {for (PolicyRule item :rules){ this.addToRules(item);}} return (T) this;
    }
    public RulesNested<T> addNewRule(){
    return new RulesNested<T>();
    }
    public RulesNested<T> addNewRuleLike( PolicyRule item){
    return new RulesNested<T>(item);
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ClusterRoleFluent that = (ClusterRoleFluent) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (rules != null ? !rules.equals(that.rules) :that.rules != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNested ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
             MetadataNested (){
        this.builder = new ObjectMetaBuilder(this);
        }
    
            public N endMetadata(){
            return and();
        }
            public N and(){
            return (N) ClusterRoleFluent.this.withMetadata(builder.build());
        }
    
}
    public class RulesNested<N> extends PolicyRuleFluent<RulesNested<N>> implements Nested<N>{

        private final PolicyRuleBuilder builder;
    
             RulesNested (){
        this.builder = new PolicyRuleBuilder(this);
        }
             RulesNested ( PolicyRule item){
        this.builder = new PolicyRuleBuilder(this, item);
        }
    
            public N endRule(){
            return and();
        }
            public N and(){
            return (N) ClusterRoleFluent.this.addToRules(builder.build());
        }
    
}


}
