package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class RoleListFluent<T extends RoleListFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     RoleList.ApiVersion apiVersion;     List<VisitableBuilder<Role, ?>> items = new ArrayList();     String kind;     VisitableBuilder<ListMeta, ?> metadata;     Map<String, Object> additionalProperties = new HashMap();

    public RoleList.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( RoleList.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public T addToItems( Role ...items){
    for (Role item : items) {RoleBuilder builder = new RoleBuilder(item);_visitables.add(builder);this.items.add(builder);} return (T)this;
    }
    public T removeFromItems( Role ...items){
    for (Role item : items) {RoleBuilder builder = new RoleBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (T)this;
    }
    public List<Role> getItems(){
    return build(items);
    }
    public T withItems( List<Role> items){
    this.items.clear();if (items != null) {for (Role item : items){this.addToItems(item);}} return (T) this;
    }
    public T withItems( Role ...items){
    this.items.clear(); if (items != null) {for (Role item :items){ this.addToItems(item);}} return (T) this;
    }
    public ItemsNested<T> addNewItem(){
    return new ItemsNested<T>();
    }
    public ItemsNested<T> addNewItemLike( Role item){
    return new ItemsNested<T>(item);
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ListMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ListMeta metadata){
    if (metadata!=null){ this.metadata= new ListMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNested<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ListMeta item){
    return new MetadataNested<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public T withNewMetadata( String resourceVersion,  String selfLink){
    return withMetadata(new ListMeta(resourceVersion, selfLink));
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
RoleListFluent that = (RoleListFluent) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (items != null ? !items.equals(that.items) :that.items != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class ItemsNested<N> extends RoleFluent<ItemsNested<N>> implements Nested<N>{

        private final RoleBuilder builder;
    
             ItemsNested (){
        this.builder = new RoleBuilder(this);
        }
             ItemsNested ( Role item){
        this.builder = new RoleBuilder(this, item);
        }
    
            public N endItem(){
            return and();
        }
            public N and(){
            return (N) RoleListFluent.this.addToItems(builder.build());
        }
    
}
    public class MetadataNested<N> extends ListMetaFluent<MetadataNested<N>> implements Nested<N>{

        private final ListMetaBuilder builder;
    
             MetadataNested (){
        this.builder = new ListMetaBuilder(this);
        }
             MetadataNested ( ListMeta item){
        this.builder = new ListMetaBuilder(this, item);
        }
    
            public N endMetadata(){
            return and();
        }
            public N and(){
            return (N) RoleListFluent.this.withMetadata(builder.build());
        }
    
}


}
