package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class ServiceAccountBuilder extends ServiceAccountFluent<ServiceAccountBuilder> implements VisitableBuilder<ServiceAccount,ServiceAccountBuilder>{

     ServiceAccountFluent<?> fluent;
public ServiceAccountBuilder(){
    this(new ServiceAccount());
}
public ServiceAccountBuilder( ServiceAccountFluent<?> fluent ){
    this(fluent, new ServiceAccount());
}
public ServiceAccountBuilder( ServiceAccountFluent<?> fluent , ServiceAccount instance ){
    this.fluent = fluent; fluent.withApiVersion(instance.getApiVersion()); fluent.withImagePullSecrets(instance.getImagePullSecrets()); fluent.withKind(instance.getKind()); fluent.withMetadata(instance.getMetadata()); fluent.withSecrets(instance.getSecrets()); 
}
public ServiceAccountBuilder( ServiceAccount instance ){
    this.fluent = this; this.withApiVersion(instance.getApiVersion()); this.withImagePullSecrets(instance.getImagePullSecrets()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); this.withSecrets(instance.getSecrets()); 
}

public EditableServiceAccount build(){
    EditableServiceAccount buildable = new EditableServiceAccount(fluent.getApiVersion(),fluent.getImagePullSecrets(),fluent.getKind(),fluent.getMetadata(),fluent.getSecrets());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
ServiceAccountBuilder that = (ServiceAccountBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    