
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "externalID",
    "podCIDR",
    "providerID",
    "unschedulable"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
public class NodeSpec {

    /**
     * deprecated. External ID assigned to the node by some machine database (e.g. a cloud provider). Defaults to node name when empty.
     * 
     */
    @JsonProperty("externalID")
    private String externalID;
    /**
     * pod IP range assigned to the node
     * 
     */
    @JsonProperty("podCIDR")
    private String podCIDR;
    /**
     * ID of the node assigned by the cloud provider in the format: <ProviderName>://<ProviderSpecificNodeID>
     * 
     */
    @JsonProperty("providerID")
    private String providerID;
    /**
     * disable pod scheduling on the node; see http://releases.k8s.io/v1.0.0/docs/node.md#manual-node-administration
     * 
     */
    @JsonProperty("unschedulable")
    private Boolean unschedulable;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public NodeSpec() {
    }

    /**
     * 
     * @param podCIDR
     * @param unschedulable
     * @param providerID
     * @param externalID
     */
    public NodeSpec(String externalID, String podCIDR, String providerID, Boolean unschedulable) {
        this.externalID = externalID;
        this.podCIDR = podCIDR;
        this.providerID = providerID;
        this.unschedulable = unschedulable;
    }

    /**
     * deprecated. External ID assigned to the node by some machine database (e.g. a cloud provider). Defaults to node name when empty.
     * 
     * @return
     *     The externalID
     */
    @JsonProperty("externalID")
    public String getExternalID() {
        return externalID;
    }

    /**
     * deprecated. External ID assigned to the node by some machine database (e.g. a cloud provider). Defaults to node name when empty.
     * 
     * @param externalID
     *     The externalID
     */
    @JsonProperty("externalID")
    public void setExternalID(String externalID) {
        this.externalID = externalID;
    }

    /**
     * pod IP range assigned to the node
     * 
     * @return
     *     The podCIDR
     */
    @JsonProperty("podCIDR")
    public String getPodCIDR() {
        return podCIDR;
    }

    /**
     * pod IP range assigned to the node
     * 
     * @param podCIDR
     *     The podCIDR
     */
    @JsonProperty("podCIDR")
    public void setPodCIDR(String podCIDR) {
        this.podCIDR = podCIDR;
    }

    /**
     * ID of the node assigned by the cloud provider in the format: <ProviderName>://<ProviderSpecificNodeID>
     * 
     * @return
     *     The providerID
     */
    @JsonProperty("providerID")
    public String getProviderID() {
        return providerID;
    }

    /**
     * ID of the node assigned by the cloud provider in the format: <ProviderName>://<ProviderSpecificNodeID>
     * 
     * @param providerID
     *     The providerID
     */
    @JsonProperty("providerID")
    public void setProviderID(String providerID) {
        this.providerID = providerID;
    }

    /**
     * disable pod scheduling on the node; see http://releases.k8s.io/v1.0.0/docs/node.md#manual-node-administration
     * 
     * @return
     *     The unschedulable
     */
    @JsonProperty("unschedulable")
    public Boolean getUnschedulable() {
        return unschedulable;
    }

    /**
     * disable pod scheduling on the node; see http://releases.k8s.io/v1.0.0/docs/node.md#manual-node-administration
     * 
     * @param unschedulable
     *     The unschedulable
     */
    @JsonProperty("unschedulable")
    public void setUnschedulable(Boolean unschedulable) {
        this.unschedulable = unschedulable;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
