package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import java.util.Map;
import java.util.List;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class TemplateBuilder extends TemplateFluent<TemplateBuilder> implements VisitableBuilder<Template,TemplateBuilder>{

     TemplateFluent<?> fluent;
public TemplateBuilder(){
    this(new Template());
}
public TemplateBuilder( TemplateFluent<?> fluent ){
    this(fluent, new Template());
}
public TemplateBuilder( TemplateFluent<?> fluent , Template instance ){
    this.fluent = fluent; fluent.withApiVersion(instance.getApiVersion()); fluent.withKind(instance.getKind()); fluent.withLabels(instance.getLabels()); fluent.withMetadata(instance.getMetadata()); fluent.withObjects(instance.getObjects()); fluent.withParameters(instance.getParameters()); 
}
public TemplateBuilder( Template instance ){
    this.fluent = this; this.withApiVersion(instance.getApiVersion()); this.withKind(instance.getKind()); this.withLabels(instance.getLabels()); this.withMetadata(instance.getMetadata()); this.withObjects(instance.getObjects()); this.withParameters(instance.getParameters()); 
}

public EditableTemplate build(){
    EditableTemplate buildable = new EditableTemplate(fluent.getApiVersion(),fluent.getKind(),fluent.getLabels(),fluent.getMetadata(),fluent.getObjects(),fluent.getParameters());
validate(buildable);
return buildable;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    