package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class PersistentVolumeListFluent<T extends PersistentVolumeListFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     PersistentVolumeList.ApiVersion apiVersion;     List<VisitableBuilder<PersistentVolume, ?>> items = new ArrayList();     String kind;     VisitableBuilder<ListMeta, ?> metadata;     Map<String, Object> additionalProperties = new HashMap();

    public PersistentVolumeList.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( PersistentVolumeList.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public T addToItems( PersistentVolume ...items){
    for (PersistentVolume item : items) {PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);_visitables.add(builder);this.items.add(builder);} return (T)this;
    }
    public List<PersistentVolume> getItems(){
    return build(items);
    }
    public T withItems( List<PersistentVolume> items){
    this.items.clear();if (items != null) {for (PersistentVolume item : items){this.addToItems(item);}} return (T) this;
    }
    public T withItems( PersistentVolume ...items){
    this.items.clear(); if (items != null) {for (PersistentVolume item :items){ this.addToItems(item);}} return (T) this;
    }
    public ItemsNested<T> addNewItem(){
    return new ItemsNested<T>();
    }
    public ItemsNested<T> addNewItemLike( PersistentVolume item){
    return new ItemsNested<T>(item);
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ListMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ListMeta metadata){
    if (metadata!=null){ this.metadata= new ListMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNested<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ListMeta item){
    return new MetadataNested<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public T withNewMetadata( String resourceVersion,  String selfLink){
    return withMetadata(new ListMeta(resourceVersion, selfLink));
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }

    public class ItemsNested<N> extends PersistentVolumeFluent<ItemsNested<N>> implements Nested<N>{

        private final PersistentVolumeBuilder builder;
    
             ItemsNested ( PersistentVolume item){
        this.builder = new PersistentVolumeBuilder(this, item);
        }
             ItemsNested (){
        this.builder = new PersistentVolumeBuilder(this);
        }
    
            public N endItem(){
            return and();
        }
            public N and(){
            return (N) PersistentVolumeListFluent.this.addToItems(builder.build());
        }
    
}
    public class MetadataNested<N> extends ListMetaFluent<MetadataNested<N>> implements Nested<N>{

        private final ListMetaBuilder builder;
    
             MetadataNested (){
        this.builder = new ListMetaBuilder(this);
        }
             MetadataNested ( ListMeta item){
        this.builder = new ListMetaBuilder(this, item);
        }
    
            public N endMetadata(){
            return and();
        }
            public N and(){
            return (N) PersistentVolumeListFluent.this.withMetadata(builder.build());
        }
    
}


}
