/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "authorizeToken", "clientName", "expiresIn", "kind", "metadata", "redirectURI", "refreshToken", "scopes", "userName", "userUID"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class OAuthAccessToken
implements HasMetadata {
    @JsonProperty(value="apiVersion")
    @NotNull
    private ApiVersion apiVersion = ApiVersion.fromValue("v1");
    @JsonProperty(value="authorizeToken")
    private String authorizeToken;
    @JsonProperty(value="clientName")
    private String clientName;
    @JsonProperty(value="expiresIn")
    private Long expiresIn;
    @JsonProperty(value="kind")
    @NotNull
    private String kind = "OAuthAccessToken";
    @JsonProperty(value="metadata")
    @Valid
    private ObjectMeta metadata;
    @JsonProperty(value="redirectURI")
    private String redirectURI;
    @JsonProperty(value="refreshToken")
    private String refreshToken;
    @JsonProperty(value="scopes")
    @Valid
    private List<String> scopes = new ArrayList<String>();
    @JsonProperty(value="userName")
    private String userName;
    @JsonProperty(value="userUID")
    private String userUID;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public OAuthAccessToken() {
    }

    public OAuthAccessToken(ApiVersion apiVersion, String authorizeToken, String clientName, Long expiresIn, String kind, ObjectMeta metadata, String redirectURI, String refreshToken, List<String> scopes, String userName, String userUID) {
        this.apiVersion = apiVersion;
        this.authorizeToken = authorizeToken;
        this.clientName = clientName;
        this.expiresIn = expiresIn;
        this.kind = kind;
        this.metadata = metadata;
        this.redirectURI = redirectURI;
        this.refreshToken = refreshToken;
        this.scopes = scopes;
        this.userName = userName;
        this.userUID = userUID;
    }

    @JsonProperty(value="apiVersion")
    public ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @JsonProperty(value="apiVersion")
    public void setApiVersion(ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="authorizeToken")
    public String getAuthorizeToken() {
        return this.authorizeToken;
    }

    @JsonProperty(value="authorizeToken")
    public void setAuthorizeToken(String authorizeToken) {
        this.authorizeToken = authorizeToken;
    }

    @JsonProperty(value="clientName")
    public String getClientName() {
        return this.clientName;
    }

    @JsonProperty(value="clientName")
    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    @JsonProperty(value="expiresIn")
    public Long getExpiresIn() {
        return this.expiresIn;
    }

    @JsonProperty(value="expiresIn")
    public void setExpiresIn(Long expiresIn) {
        this.expiresIn = expiresIn;
    }

    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    @Override
    @JsonProperty(value="metadata")
    public ObjectMeta getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="metadata")
    public void setMetadata(ObjectMeta metadata) {
        this.metadata = metadata;
    }

    @JsonProperty(value="redirectURI")
    public String getRedirectURI() {
        return this.redirectURI;
    }

    @JsonProperty(value="redirectURI")
    public void setRedirectURI(String redirectURI) {
        this.redirectURI = redirectURI;
    }

    @JsonProperty(value="refreshToken")
    public String getRefreshToken() {
        return this.refreshToken;
    }

    @JsonProperty(value="refreshToken")
    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    @JsonProperty(value="scopes")
    public List<String> getScopes() {
        return this.scopes;
    }

    @JsonProperty(value="scopes")
    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    @JsonProperty(value="userName")
    public String getUserName() {
        return this.userName;
    }

    @JsonProperty(value="userName")
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @JsonProperty(value="userUID")
    public String getUserUID() {
        return this.userUID;
    }

    @JsonProperty(value="userUID")
    public void setUserUID(String userUID) {
        this.userUID = userUID;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return "OAuthAccessToken(apiVersion=" + (Object)((Object)this.getApiVersion()) + ", authorizeToken=" + this.getAuthorizeToken() + ", clientName=" + this.getClientName() + ", expiresIn=" + this.getExpiresIn() + ", kind=" + this.getKind() + ", metadata=" + this.getMetadata() + ", redirectURI=" + this.getRedirectURI() + ", refreshToken=" + this.getRefreshToken() + ", scopes=" + this.getScopes() + ", userName=" + this.getUserName() + ", userUID=" + this.getUserUID() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuthAccessToken)) {
            return false;
        }
        OAuthAccessToken other = (OAuthAccessToken)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ApiVersion this$apiVersion = this.getApiVersion();
        ApiVersion other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !((Object)((Object)this$apiVersion)).equals((Object)other$apiVersion)) {
            return false;
        }
        String this$authorizeToken = this.getAuthorizeToken();
        String other$authorizeToken = other.getAuthorizeToken();
        if (this$authorizeToken == null ? other$authorizeToken != null : !this$authorizeToken.equals(other$authorizeToken)) {
            return false;
        }
        String this$clientName = this.getClientName();
        String other$clientName = other.getClientName();
        if (this$clientName == null ? other$clientName != null : !this$clientName.equals(other$clientName)) {
            return false;
        }
        Long this$expiresIn = this.getExpiresIn();
        Long other$expiresIn = other.getExpiresIn();
        if (this$expiresIn == null ? other$expiresIn != null : !((Object)this$expiresIn).equals(other$expiresIn)) {
            return false;
        }
        String this$kind = this.getKind();
        String other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !this$kind.equals(other$kind)) {
            return false;
        }
        ObjectMeta this$metadata = this.getMetadata();
        ObjectMeta other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$redirectURI = this.getRedirectURI();
        String other$redirectURI = other.getRedirectURI();
        if (this$redirectURI == null ? other$redirectURI != null : !this$redirectURI.equals(other$redirectURI)) {
            return false;
        }
        String this$refreshToken = this.getRefreshToken();
        String other$refreshToken = other.getRefreshToken();
        if (this$refreshToken == null ? other$refreshToken != null : !this$refreshToken.equals(other$refreshToken)) {
            return false;
        }
        List<String> this$scopes = this.getScopes();
        List<String> other$scopes = other.getScopes();
        if (this$scopes == null ? other$scopes != null : !((Object)this$scopes).equals(other$scopes)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$userUID = this.getUserUID();
        String other$userUID = other.getUserUID();
        if (this$userUID == null ? other$userUID != null : !this$userUID.equals(other$userUID)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OAuthAccessToken;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ApiVersion $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 0 : ((Object)((Object)$apiVersion)).hashCode());
        String $authorizeToken = this.getAuthorizeToken();
        result = result * 59 + ($authorizeToken == null ? 0 : $authorizeToken.hashCode());
        String $clientName = this.getClientName();
        result = result * 59 + ($clientName == null ? 0 : $clientName.hashCode());
        Long $expiresIn = this.getExpiresIn();
        result = result * 59 + ($expiresIn == null ? 0 : ((Object)$expiresIn).hashCode());
        String $kind = this.getKind();
        result = result * 59 + ($kind == null ? 0 : $kind.hashCode());
        ObjectMeta $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 0 : ((Object)$metadata).hashCode());
        String $redirectURI = this.getRedirectURI();
        result = result * 59 + ($redirectURI == null ? 0 : $redirectURI.hashCode());
        String $refreshToken = this.getRefreshToken();
        result = result * 59 + ($refreshToken == null ? 0 : $refreshToken.hashCode());
        List<String> $scopes = this.getScopes();
        result = result * 59 + ($scopes == null ? 0 : ((Object)$scopes).hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 0 : $userName.hashCode());
        String $userUID = this.getUserUID();
        result = result * 59 + ($userUID == null ? 0 : $userUID.hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 0 : ((Object)$additionalProperties).hashCode());
        return result;
    }

    public static enum ApiVersion {
        V_1("v1");

        private final String value;
        private static Map<String, ApiVersion> constants;

        private ApiVersion(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ApiVersion fromValue(String value) {
            ApiVersion constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            constants = new HashMap<String, ApiVersion>();
            for (ApiVersion c : ApiVersion.values()) {
                constants.put(c.value, c);
            }
        }
    }
}

