
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "capabilities",
    "privileged",
    "runAsUser",
    "seLinuxOptions"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
public class SecurityContext {

    /**
     * 
     * 
     */
    @JsonProperty("capabilities")
    @Valid
    private Capabilities capabilities;
    /**
     * run the container in privileged mode; see http://releases.k8s.io/v1.0.0/docs/design/security_context.md#security-context
     * 
     */
    @JsonProperty("privileged")
    private Boolean privileged;
    /**
     * the user id that runs the first process in the container; see http://releases.k8s.io/v1.0.0/docs/design/security_context.md#security-context
     * 
     */
    @JsonProperty("runAsUser")
    private Long runAsUser;
    /**
     * 
     * 
     */
    @JsonProperty("seLinuxOptions")
    @Valid
    private SELinuxOptions seLinuxOptions;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public SecurityContext() {
    }

    /**
     * 
     * @param seLinuxOptions
     * @param privileged
     * @param capabilities
     * @param runAsUser
     */
    public SecurityContext(Capabilities capabilities, Boolean privileged, Long runAsUser, SELinuxOptions seLinuxOptions) {
        this.capabilities = capabilities;
        this.privileged = privileged;
        this.runAsUser = runAsUser;
        this.seLinuxOptions = seLinuxOptions;
    }

    /**
     * 
     * 
     * @return
     *     The capabilities
     */
    @JsonProperty("capabilities")
    public Capabilities getCapabilities() {
        return capabilities;
    }

    /**
     * 
     * 
     * @param capabilities
     *     The capabilities
     */
    @JsonProperty("capabilities")
    public void setCapabilities(Capabilities capabilities) {
        this.capabilities = capabilities;
    }

    /**
     * run the container in privileged mode; see http://releases.k8s.io/v1.0.0/docs/design/security_context.md#security-context
     * 
     * @return
     *     The privileged
     */
    @JsonProperty("privileged")
    public Boolean getPrivileged() {
        return privileged;
    }

    /**
     * run the container in privileged mode; see http://releases.k8s.io/v1.0.0/docs/design/security_context.md#security-context
     * 
     * @param privileged
     *     The privileged
     */
    @JsonProperty("privileged")
    public void setPrivileged(Boolean privileged) {
        this.privileged = privileged;
    }

    /**
     * the user id that runs the first process in the container; see http://releases.k8s.io/v1.0.0/docs/design/security_context.md#security-context
     * 
     * @return
     *     The runAsUser
     */
    @JsonProperty("runAsUser")
    public Long getRunAsUser() {
        return runAsUser;
    }

    /**
     * the user id that runs the first process in the container; see http://releases.k8s.io/v1.0.0/docs/design/security_context.md#security-context
     * 
     * @param runAsUser
     *     The runAsUser
     */
    @JsonProperty("runAsUser")
    public void setRunAsUser(Long runAsUser) {
        this.runAsUser = runAsUser;
    }

    /**
     * 
     * 
     * @return
     *     The seLinuxOptions
     */
    @JsonProperty("seLinuxOptions")
    public SELinuxOptions getSeLinuxOptions() {
        return seLinuxOptions;
    }

    /**
     * 
     * 
     * @param seLinuxOptions
     *     The seLinuxOptions
     */
    @JsonProperty("seLinuxOptions")
    public void setSeLinuxOptions(SELinuxOptions seLinuxOptions) {
        this.seLinuxOptions = seLinuxOptions;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
