package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class EndpointAddressBuilder extends EndpointAddressFluent<EndpointAddressBuilder> implements VisitableBuilder<EndpointAddress,EndpointAddressBuilder>{

     EndpointAddressFluent<?> fluent;
public EndpointAddressBuilder(){
    this(new EndpointAddress());
}
public EndpointAddressBuilder( EndpointAddressFluent<?> fluent ){
    this(fluent, new EndpointAddress());
}
public EndpointAddressBuilder( EndpointAddressFluent<?> fluent , EndpointAddress instance ){
    this.fluent = fluent; fluent.withIp(instance.getIp()); fluent.withTargetRef(instance.getTargetRef()); 
}
public EndpointAddressBuilder( EndpointAddress instance ){
    this.fluent = this; this.withIp(instance.getIp()); this.withTargetRef(instance.getTargetRef()); 
}

public EditableEndpointAddress build(){
    EditableEndpointAddress buildable = new EditableEndpointAddress(fluent.getIp(),fluent.getTargetRef());
validate(buildable);
return buildable;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    