package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class SourceRevisionFluent<T extends SourceRevisionFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     VisitableBuilder<GitSourceRevision, ?> git;     String type;     Map<String, Object> additionalProperties = new HashMap();

    public GitSourceRevision getGit(){
    return this.git!=null?this.git.build():null;
    }
    public T withGit( GitSourceRevision git){
    if (git!=null){ this.git= new GitSourceRevisionBuilder(git); _visitables.add(this.git);} return (T) this;
    }
    public GitNested<T> withNewGit(){
    return new GitNested<T>();
    }
    public GitNested<T> withNewGitLike( GitSourceRevision item){
    return new GitNested<T>(item);
    }
    public GitNested<T> editGit(){
    return withNewGitLike(getGit());
    }
    public String getType(){
    return this.type;
    }
    public T withType( String type){
    this.type=type; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }

    public class GitNested<N> extends GitSourceRevisionFluent<GitNested<N>> implements Nested<N>{

        private final GitSourceRevisionBuilder builder;
    
             GitNested ( GitSourceRevision item){
        this.builder = new GitSourceRevisionBuilder(this, item);
        }
             GitNested (){
        this.builder = new GitSourceRevisionBuilder(this);
        }
    
            public N endGit(){
            return and();
        }
            public N and(){
            return (N) SourceRevisionFluent.this.withGit(builder.build());
        }
    
}


}
