
package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "details",
    "latestVersion"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
public class DeploymentConfigStatus {

    /**
     * 
     * 
     */
    @JsonProperty("details")
    @Valid
    private DeploymentDetails details;
    /**
     * used to determine whether the current deployment is out of sync
     * 
     */
    @JsonProperty("latestVersion")
    private Integer latestVersion;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public DeploymentConfigStatus() {
    }

    /**
     * 
     * @param latestVersion
     * @param details
     */
    public DeploymentConfigStatus(DeploymentDetails details, Integer latestVersion) {
        this.details = details;
        this.latestVersion = latestVersion;
    }

    /**
     * 
     * 
     * @return
     *     The details
     */
    @JsonProperty("details")
    public DeploymentDetails getDetails() {
        return details;
    }

    /**
     * 
     * 
     * @param details
     *     The details
     */
    @JsonProperty("details")
    public void setDetails(DeploymentDetails details) {
        this.details = details;
    }

    /**
     * used to determine whether the current deployment is out of sync
     * 
     * @return
     *     The latestVersion
     */
    @JsonProperty("latestVersion")
    public Integer getLatestVersion() {
        return latestVersion;
    }

    /**
     * used to determine whether the current deployment is out of sync
     * 
     * @param latestVersion
     *     The latestVersion
     */
    @JsonProperty("latestVersion")
    public void setLatestVersion(Integer latestVersion) {
        this.latestVersion = latestVersion;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(details).append(latestVersion).append(additionalProperties).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DeploymentConfigStatus) == false) {
            return false;
        }
        DeploymentConfigStatus rhs = ((DeploymentConfigStatus) other);
        return new EqualsBuilder().append(details, rhs.details).append(latestVersion, rhs.latestVersion).append(additionalProperties, rhs.additionalProperties).isEquals();
    }

}
