
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "object",
    "type"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
public class WatchEvent {

    /**
     * 
     * 
     */
    @JsonProperty("object")
    @Valid
    private HasMetadata object;
    /**
     * the type of watch event; may be ADDED
     * 
     */
    @JsonProperty("type")
    private String type;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public WatchEvent() {
    }

    /**
     * 
     * @param object
     * @param type
     */
    public WatchEvent(HasMetadata object, String type) {
        this.object = object;
        this.type = type;
    }

    /**
     * 
     * 
     * @return
     *     The object
     */
    @JsonProperty("object")
    public HasMetadata getObject() {
        return object;
    }

    /**
     * 
     * 
     * @param object
     *     The object
     */
    @JsonProperty("object")
    public void setObject(HasMetadata object) {
        this.object = object;
    }

    /**
     * the type of watch event; may be ADDED
     * 
     * @return
     *     The type
     */
    @JsonProperty("type")
    public String getType() {
        return type;
    }

    /**
     * the type of watch event; may be ADDED
     * 
     * @param type
     *     The type
     */
    @JsonProperty("type")
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(object).append(type).append(additionalProperties).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof WatchEvent) == false) {
            return false;
        }
        WatchEvent rhs = ((WatchEvent) other);
        return new EqualsBuilder().append(object, rhs.object).append(type, rhs.type).append(additionalProperties, rhs.additionalProperties).isEquals();
    }

}
