package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class TCPSocketActionBuilder extends TCPSocketActionFluent<TCPSocketActionBuilder> implements VisitableBuilder<TCPSocketAction,TCPSocketActionBuilder>{

     TCPSocketActionFluent<?> fluent;
public TCPSocketActionBuilder(){
    this(new TCPSocketAction());
}
public TCPSocketActionBuilder( TCPSocketActionFluent<?> fluent ){
    this(fluent, new TCPSocketAction());
}
public TCPSocketActionBuilder( TCPSocketActionFluent<?> fluent , TCPSocketAction instance ){
    this.fluent = fluent; fluent.withPort(instance.getPort()); 
}
public TCPSocketActionBuilder( TCPSocketAction instance ){
    this.fluent = this; this.withPort(instance.getPort()); 
}

public EditableTCPSocketAction build(){
    EditableTCPSocketAction buildable = new EditableTCPSocketAction(fluent.getPort());
validate(buildable);
return buildable;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    