
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "message",
    "phase",
    "reason"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
public class PersistentVolumeStatus {

    /**
     * human-readable message indicating details about why the volume is in this state
     * 
     */
    @JsonProperty("message")
    private String message;
    /**
     * the current phase of a persistent volume
     * 
     */
    @JsonProperty("phase")
    private String phase;
    /**
     * (brief) reason the volume is not is not available
     * 
     */
    @JsonProperty("reason")
    private String reason;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public PersistentVolumeStatus() {
    }

    /**
     * 
     * @param message
     * @param reason
     * @param phase
     */
    public PersistentVolumeStatus(String message, String phase, String reason) {
        this.message = message;
        this.phase = phase;
        this.reason = reason;
    }

    /**
     * human-readable message indicating details about why the volume is in this state
     * 
     * @return
     *     The message
     */
    @JsonProperty("message")
    public String getMessage() {
        return message;
    }

    /**
     * human-readable message indicating details about why the volume is in this state
     * 
     * @param message
     *     The message
     */
    @JsonProperty("message")
    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * the current phase of a persistent volume
     * 
     * @return
     *     The phase
     */
    @JsonProperty("phase")
    public String getPhase() {
        return phase;
    }

    /**
     * the current phase of a persistent volume
     * 
     * @param phase
     *     The phase
     */
    @JsonProperty("phase")
    public void setPhase(String phase) {
        this.phase = phase;
    }

    /**
     * (brief) reason the volume is not is not available
     * 
     * @return
     *     The reason
     */
    @JsonProperty("reason")
    public String getReason() {
        return reason;
    }

    /**
     * (brief) reason the volume is not is not available
     * 
     * @param reason
     *     The reason
     */
    @JsonProperty("reason")
    public void setReason(String reason) {
        this.reason = reason;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(message).append(phase).append(reason).append(additionalProperties).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof PersistentVolumeStatus) == false) {
            return false;
        }
        PersistentVolumeStatus rhs = ((PersistentVolumeStatus) other);
        return new EqualsBuilder().append(message, rhs.message).append(phase, rhs.phase).append(reason, rhs.reason).append(additionalProperties, rhs.additionalProperties).isEquals();
    }

}
